<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Goods\Service;

use Doctrine\ORM\EntityManager;
use Goods\Entity\GoodsInSpecImage;

class GoodsInSpecImageManager
{
    private $entityManager;

    public function __construct(
        EntityManager $entityManager
    )
    {
        $this->entityManager = $entityManager;
    }

    /**
     * 添加规格图片
     * @param array $data
     * @param $imageGroupId
     * @param $goodsId
     * @return bool
     * @throws \Doctrine\Common\Persistence\Mapping\MappingException
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function addInSpecImage(array $data, $imageGroupId, $goodsId)
    {
        if($imageGroupId > 0 && isset($data['goodsSpecGroup'.$imageGroupId]) && !empty($data['goodsSpecGroup'.$imageGroupId])) {
            foreach ($data['goodsSpecGroup'.$imageGroupId] as $tagId) {
                if(isset($data['specGoodsImageStr'][$tagId]) && !empty($data['specGoodsImageStr'][$tagId])) {
                    $imageGoodsIdArray = explode(',', $data['specGoodsImageStr'][$tagId]);
                    foreach ($imageGoodsIdArray as $goodsImageId) {
                        $goodsInSpecImage = new GoodsInSpecImage();
                        $goodsInSpecImage->valuesSet([
                            'tagId'         => $tagId,
                            'goodsId'       => $goodsId,
                            'goodsImageId' => $goodsImageId
                        ]);
                        $this->entityManager->persist($goodsInSpecImage);
                        $this->entityManager->flush();
                        $this->entityManager->clear(GoodsInSpecImage::class);
                    }
                }
            }
        }
        return true;
    }

    /**
     * 编辑规格图片
     * @param array $data
     * @param $imageGroupId
     * @param $goodsId
     * @return bool
     * @throws \Doctrine\Common\Persistence\Mapping\MappingException
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function editInSpecImage(array $data, $imageGroupId, $goodsId)
    {
        if($imageGroupId > 0 && isset($data['goodsSpecGroup'.$imageGroupId]) && !empty($data['goodsSpecGroup'.$imageGroupId])) {
            $tagIdImage = [];
            $inSpecImage = $this->entityManager->getRepository(GoodsInSpecImage::class)->findBy(['goodsId' => $goodsId]);
            if($inSpecImage) foreach ($inSpecImage as $siValue) {
                if(!in_array($siValue->getTagId(), $data['goodsSpecGroup'.$imageGroupId])) {
                    $this->entityManager->remove($siValue);
                    $this->entityManager->flush();
                } else {
                    if(!isset($imageGoodsIdArray[$siValue->getTagId()])) $imageGoodsIdArray[$siValue->getTagId()] = explode(',', $data['specGoodsImageStr'][$siValue->getTagId()]);
                    if(empty($imageGoodsIdArray[$siValue->getTagId()]) || (!empty($imageGoodsIdArray[$siValue->getTagId()]) && !in_array($siValue->getGoodsImageId(), $imageGoodsIdArray[$siValue->getTagId()]))) {
                        $this->entityManager->remove($siValue);
                        $this->entityManager->flush();
                    } else {
                        $tagIdImage[$siValue->getTagId()][] = $siValue->getGoodsImageId();
                    }
                }
            }

            if(!empty($data['goodsSpecGroup'.$imageGroupId])) {
                foreach ($data['goodsSpecGroup'.$imageGroupId] as $tagId) {
                    if(isset($data['specGoodsImageStr'][$tagId]) && !empty($data['specGoodsImageStr'][$tagId])) {
                        $imageGoodsIdArray = explode(',', $data['specGoodsImageStr'][$tagId]);
                        foreach ($imageGoodsIdArray as $goodsImageId) {
                            if(isset($tagIdImage[$tagId]) && in_array($goodsImageId, $tagIdImage[$tagId])) continue;

                            $goodsInSpecImage = new GoodsInSpecImage();
                            $goodsInSpecImage->valuesSet([
                                'tagId'         => $tagId,
                                'goodsId'       => $goodsId,
                                'goodsImageId' => $goodsImageId
                            ]);
                            $this->entityManager->persist($goodsInSpecImage);
                            $this->entityManager->flush();
                            $this->entityManager->clear(GoodsInSpecImage::class);
                        }
                    }
                }
            }
        } else {
            $qb = $this->entityManager->createQueryBuilder();
            $qb->delete(GoodsInSpecImage::class, 'si')->where('si.goodsId = :goodsId')->setParameter('goodsId', $goodsId);
            $qb->getQuery()->execute();
        }
        return true;
    }

    /**
     * 删除多个商品中的同一个图片
     * @param $goodsImageId
     */
    public function deleteMoreSpecImage($goodsImageId)
    {
        $qb = $this->entityManager->createQueryBuilder();
        $qb->delete(GoodsInSpecImage::class, 'si')->where('si.goodsImageId = :goodsImageId')->setParameter('goodsImageId', $goodsImageId);
        $qb->getQuery()->execute();
    }

    /**
     * 根据商品id删除规格对应的图片
     * @param $goodsId
     */
    public function deleteSpecImageGoodsId($goodsId)
    {
        $qb = $this->entityManager->createQueryBuilder();
        $qb->delete(GoodsInSpecImage::class, 'si')->where('si.goodsId = :goodsId')->setParameter('goodsId', $goodsId);
        $qb->getQuery()->execute();
    }
}