<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Goods\Service;

use Doctrine\ORM\EntityManager;
use Goods\Entity\GoodsInWholesale;

class GoodsInWholesaleManager
{
    private $entityManager;

    public function __construct(
        EntityManager $entityManager
    )
    {
        $this->entityManager = $entityManager;
    }

    /**
     * 添加商品批发信息
     * @param array $data
     * @param $goodsId
     * @return bool
     * @throws \Doctrine\Common\Persistence\Mapping\MappingException
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function addGoodsWholesale(array $data, $goodsId)
    {
        foreach ($data['wholesaleStartNum'] as $key => $value) {
            if($value > 0 && $data['wholesaleEndNum'][$key] > 0 && $data['wholesalePrice'][$key] > 0) {
                $goodsInWholesale = new GoodsInWholesale();
                $goodsInWholesale->valuesSet([
                    'goodsId' => $goodsId,
                    'wholesaleStartNum' => (int) $value,
                    'wholesaleEndNum'   => (int) $data['wholesaleEndNum'][$key],
                    'wholesalePrice'    => floatval($data['wholesalePrice'][$key]),
                    'wholesaleKey'      => (int) $key
                ]);
                $this->entityManager->persist($goodsInWholesale);
                $this->entityManager->flush();
                $this->entityManager->clear(GoodsInWholesale::class);
            }
        }

        return true;
    }

    /**
     * 编辑商品批发信息
     * @param array $data
     * @param $goodsId
     * @return bool
     * @throws \Doctrine\Common\Persistence\Mapping\MappingException
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function editGoodsWholesale(array $data, $goodsId)
    {
        foreach ($data['wholesaleStartNum'] as $key => $value) {
            $inGoodsWholesale = $this->entityManager->getRepository(GoodsInWholesale::class)->findOneBy(['goodsId' => $goodsId, 'wholesaleKey' => $key]);
            if($inGoodsWholesale) {
                if($value > 0 && $data['wholesaleEndNum'][$key] > 0 && $data['wholesalePrice'][$key] > 0) {
                    $inGoodsWholesale->valuesSet([
                        'wholesaleStartNum' => (int) $value,
                        'wholesaleEndNum'   => (int) $data['wholesaleEndNum'][$key],
                        'wholesalePrice'    => floatval($data['wholesalePrice'][$key])
                    ]);
                } else $this->entityManager->remove($inGoodsWholesale);
                $this->entityManager->flush();
            } else {
                if($value > 0 && $data['wholesaleEndNum'][$key] > 0 && $data['wholesalePrice'][$key] > 0) {
                    $goodsInWholesale = new GoodsInWholesale();
                    $goodsInWholesale->valuesSet([
                        'goodsId' => $goodsId,
                        'wholesaleStartNum' => (int) $value,
                        'wholesaleEndNum'   => (int) $data['wholesaleEndNum'][$key],
                        'wholesalePrice'    => floatval($data['wholesalePrice'][$key]),
                        'wholesaleKey'      => (int) $key
                    ]);
                    $this->entityManager->persist($goodsInWholesale);
                    $this->entityManager->flush();
                    $this->entityManager->clear(GoodsInWholesale::class);
                }
            }
        }
        return true;
    }

    /**
     * 通过商品id删除商品批发信息
     * @param $goodsId
     */
    public function deleteGoodsWholesaleGoodsId($goodsId)
    {
        $qb = $this->entityManager->createQueryBuilder();
        $qb->delete(GoodsInWholesale::class, 'i')->where('i.goodsId = :goodsId')->setParameter('goodsId', $goodsId);
        $qb->getQuery()->execute();
    }
}