<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Goods\Service;

use Doctrine\ORM\EntityManager;
use Goods\Entity\GoodsSpecTagGoods;

class GoodsSpecTagGoodsManager
{
    private $entityManager;

    public function __construct(
        EntityManager $entityManager
    )
    {
        $this->entityManager = $entityManager;
    }

    /**
     * 添加特定标签商品
     * @param array $data
     * @return GoodsSpecTagGoods
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function addSpecTagGoods(array $data)
    {
        $specTagGoods = new GoodsSpecTagGoods();
        $specTagGoods->valuesSet($data);

        $this->entityManager->persist($specTagGoods);
        $this->entityManager->flush();

        return $specTagGoods;
    }

    /**
     * 编辑特定标签商品
     * @param array $data
     * @param GoodsSpecTagGoods $goodsSpecTagGoods
     * @return GoodsSpecTagGoods
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function editSpecTagGoods(array $data, GoodsSpecTagGoods $goodsSpecTagGoods)
    {
        $goodsSpecTagGoods->valuesSet($data);
        $this->entityManager->flush();

        return $goodsSpecTagGoods;
    }

    /**
     * 批量修改特定标签商品排序
     * @param array $data
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     * @throws \Doctrine\Persistence\Mapping\MappingException
     */
    public function updateSpecTagAllGoodsSort(array $data)
    {
        foreach ($data['specTagGoodsId'] as $value) {
            $specTagGoodsInfo = $this->entityManager->getRepository(GoodsSpecTagGoods::class)->findOneBy(['specTagGoodsId' => $value]);
            if ($specTagGoodsInfo) {
                $specTagGoodsInfo->setSpecTagGoodsSort($data['specTagGoodsSort'.$value]);
            }
        }
        $this->entityManager->flush();
        $this->entityManager->clear(GoodsSpecTagGoods::class);
    }

    /**
     * 删除特定标签商品
     * @param GoodsSpecTagGoods $goodsSpecTagGoods
     * @return bool
     * @throws \Doctrine\ORM\ORMException
     */
    public function deleteSpecTagGoods(GoodsSpecTagGoods $goodsSpecTagGoods)
    {
        $this->entityManager->remove($goodsSpecTagGoods);
        $this->entityManager->flush();
        
        return true;
    }

    /**
     * 删除掉对应商品的特定商品显示
     * @param $goodsId
     * @return bool
     */
    public function deleteMoreSpecTagGoods($goodsId)
    {
        $qb = $this->entityManager->createQueryBuilder();
        $qb->delete(GoodsSpecTagGoods::class, 's')->where('s.goodsId = :goodsId')->setParameter('goodsId', $goodsId);
        $qb->getQuery()->execute();

        return true;
    }
}