<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Goods\Service;


use Doctrine\ORM\EntityManager;
use Goods\Entity\GoodsSpecTag;

class GoodsSpecTagManager
{
    private $entityManager;

    public function __construct(
        EntityManager $entityManager
    )
    {
        $this->entityManager = $entityManager;
    }

    /**
     * 商品特定标签添加
     * @param array $data
     * @return GoodsSpecTag
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function addSpecTag(array $data)
    {
        $specTag = new GoodsSpecTag();
        $specTag->valuesSet($data);

        $this->entityManager->persist($specTag);
        $this->entityManager->flush();

        return $specTag;
    }

    /**
     * 商品特定标签编辑
     * @param array $data
     * @param GoodsSpecTag $goodsSpecTag
     * @return GoodsSpecTag
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function editSpecTag(array $data, GoodsSpecTag $goodsSpecTag)
    {
        $goodsSpecTag->valuesSet($data);
        $this->entityManager->flush();

        return $goodsSpecTag;
    }

    /**
     * 删除特定商品标签
     * @param GoodsSpecTag $goodsSpecTag
     * @return bool
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function deleteSpecTag(GoodsSpecTag $goodsSpecTag)
    {
        $this->entityManager->remove($goodsSpecTag);
        $this->entityManager->flush();

        return true;
    }
}