<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Goods\Service;

use Doctrine\ORM\EntityManager;
use Goods\Entity\GoodsTag;
use Goods\Entity\GoodsTagGroup;

class GoodsTagManager
{
    private $entityManager;

    public function __construct(
        EntityManager $entityManager
    )
    {
        $this->entityManager = $entityManager;
    }
    
    /**
     * 添加商品标签
     * @param array $data
     * @return bool
     * @throws \Doctrine\Common\Persistence\Mapping\MappingException
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function addGoodsTag(array $data)
    {
        $tagGroup = $this->entityManager->getRepository(GoodsTagGroup::class)->findOneByTagGroupId($data['tagGroupId']);

        $tagName = explode("\r\n", $data['tagName']);
        foreach ($tagName as $value) {
            $data['tagName'] = $value;
            $goodsTag = new GoodsTag();
            $goodsTag->valuesSet($data);
            $goodsTag->setOneTagGroup($tagGroup);

            $this->entityManager->persist($goodsTag);
        }

        $this->entityManager->flush();
        $this->entityManager->clear(GoodsTag::class);

        return true;
    }

    /**
     * 编辑商品标签
     * @param array $data
     * @param GoodsTag $goodsTag
     * @return bool
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function editGoodsTag(array $data, GoodsTag $goodsTag)
    {
        $goodsTag->valuesSet($data);
        $this->entityManager->flush();

        return true;
    }

    /**
     * 删除商品标签
     * @param GoodsTag $goodsTag
     * @return bool
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function deleteGoodsTag(GoodsTag $goodsTag)
    {
        $this->entityManager->remove($goodsTag);
        $this->entityManager->flush();

        return true;
    }

    /**
     * 批量删除商品标签
     * @param $tagIdArray
     */
    public function deleteMoreGoodsTag($tagIdArray)
    {
        $qb = $this->entityManager->createQueryBuilder();
        $qb->delete(GoodsTag::class, 't')->where($qb->expr()->in('t.tagId', $tagIdArray));
        $qb->getQuery()->execute();
    }

    /**
     * 批量修改标签排序
     * @param array $data
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     * @throws \Doctrine\Persistence\Mapping\MappingException
     */
    public function updateAllTagSort(array $data)
    {
        foreach ($data['select_id'] as $value) {
            $tagInfo = $this->entityManager->getRepository(GoodsTag::class)->findOneByTagId(intval($value));
            if($tagInfo) {
                $tagInfo->setTagSort($data['tagSort'][$value]);
            }
        }
        $this->entityManager->flush();
        $this->entityManager->clear(GoodsTag::class);
    }
}