<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Goods\View;

use Admin\Data\Common;
use Laminas\Mvc\I18n\Translator;
use Laminas\View\Helper\AbstractHelper;

class GoodsHelper extends AbstractHelper
{
    private $translator;

    public function __construct(
        Translator  $translator
    )
    {
        $this->translator   = $translator;
    }

    /**
     * 虚拟商品具体类型
     * @param $type
     * @return mixed
     */
    public function getVirtualGoodsType($type)
    {
        $data = Common::virtualGoodsType($this->translator);
        return $data[$type];
    }

    /**
     * 虚拟商品具体状态
     * @param $state
     * @return mixed
     */
    public function getVirtualGoodsState($state)
    {
        $data = Common::virtualGoodsState($this->translator);
        return $data[$state];
    }

    /**
     * 商品图片
     * @param $image
     * @return array|mixed
     */
    public function goodsImage($image)
    {
        if(empty($image)) $image = Common::configValue('goods_image_default');
        $image = $this->getView()->basePath($image);

        return $image;
    }

    /**
     * 商品类型
     * @param $type
     * @return mixed
     */
    public function goodsType($type)
    {
        $goodsType = Common::goodsType($this->translator);
        return $goodsType[$type];
    }

    /**
     * 商品状态
     * @param $state
     * @return mixed
     */
    public function goodsState($state)
    {
        $goodsState = Common::goodsState($this->translator, 2);
        return $goodsState[$state];
    }

    /**
     * 商品分类状态
     * @param $state
     * @return mixed
     */
    public function goodsClassState($state)
    {
        $classState = Common::state($this->translator, 2);

        return $classState[$state];
    }

    /**
     * 商品通用内容状态
     * @param $state
     * @return mixed
     */
    public function goodsCommonContentState($state)
    {
        $contentState = Common::state($this->translator, 2);

        return $contentState[$state];
    }

    /**
     * 标签组是否用于商品规格
     * @param $state
     * @return mixed
     */
    public function goodsTagGroupIsSpec($state)
    {
        $isSpec = Common::generalState($this->translator);

        return $isSpec[$state];
    }

    /**
     * 商品属性类型
     * @param $attributeType
     * @return mixed
     */
    public function goodsAttributeType($attributeType)
    {
        $typeArray = Common::goodsAttributeType($this->translator);

        return $typeArray[$attributeType];
    }
}