DROP TABLE IF EXISTS `dbshop_ad`;
CREATE TABLE IF NOT EXISTS `dbshop_ad` (
  `ad_id` int(11) NOT NULL AUTO_INCREMENT,
  `ad_class` varchar(30) NOT NULL,
  `ad_place_code` varchar(50) NOT NULL,
  `goods_class_id_str` varchar(500) DEFAULT NULL,
  `ad_type` varchar(20) NOT NULL,
  `ad_width` int(11) DEFAULT NULL,
  `ad_height` int(11) DEFAULT NULL,
  `ad_start_time` int(10) DEFAULT '0',
  `ad_end_time` int(10) DEFAULT '0',
  `ad_url` varchar(500) DEFAULT NULL,
  `ad_body` varchar(500) DEFAULT NULL,
  `ad_state` tinyint(1) NOT NULL DEFAULT '1',
  `template_code` varchar(50) NOT NULL,
  PRIMARY KEY (`ad_id`),
  KEY `ad_class` (`ad_class`,`ad_place_code`,`template_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='广告表';

DROP TABLE IF EXISTS `dbshop_admin`;
CREATE TABLE IF NOT EXISTS `dbshop_admin` (
  `admin_id` int(11) NOT NULL AUTO_INCREMENT,
  `admin_group_id` int(11) NOT NULL,
  `admin_name` varchar(100) NOT NULL,
  `admin_passwd` varchar(72) NOT NULL,
  `admin_email` varchar(100) NOT NULL,
  `admin_state` tinyint(2) NOT NULL DEFAULT '1',
  `admin_add_time` int(10) NOT NULL,
  `admin_old_login_time` int(10) DEFAULT NULL,
  `admin_new_login_time` int(10) DEFAULT NULL,
  PRIMARY KEY (`admin_id`),
  KEY `admin_name` (`admin_name`,`admin_email`),
  KEY `admin_group_id` (`admin_group_id`),
  KEY `admin_state` (`admin_state`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

DROP TABLE IF EXISTS `dbshop_admin_group`;
CREATE TABLE IF NOT EXISTS `dbshop_admin_group` (
  `admin_group_id` int(11) NOT NULL AUTO_INCREMENT,
  `admin_group_name` varchar(200) NOT NULL,
  `admin_group_purview` text,
  PRIMARY KEY (`admin_group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

DROP TABLE IF EXISTS `dbshop_ad_slide`;
CREATE TABLE IF NOT EXISTS `dbshop_ad_slide` (
  `ad_slide_id` int(11) NOT NULL AUTO_INCREMENT,
  `ad_id` int(11) NOT NULL,
  `ad_slide_image` varchar(300) DEFAULT NULL,
  `ad_slide_sort` int(11) NOT NULL DEFAULT '255',
  `ad_slide_url` varchar(500) DEFAULT NULL,
  PRIMARY KEY (`ad_slide_id`),
  KEY `ad_id` (`ad_id`,`ad_slide_sort`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='幻灯片广告';

DROP TABLE IF EXISTS `dbshop_cart`;
CREATE TABLE IF NOT EXISTS `dbshop_cart` (
  `cart_id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `goods_id` int(11) NOT NULL,
  `in_spec_goods_id` int(11) DEFAULT '0',
  `in_wholesale_id` int(11) DEFAULT '0',
  `buy_num` int(11) NOT NULL,
  `goods_checked` tinyint(1) NOT NULL DEFAULT '1',
  `buy_now` tinyint(1) DEFAULT '0',
  `goods_remark` varchar(500) DEFAULT NULL,
  `add_time` int(10) NOT NULL,
  `update_time` int(10) DEFAULT NULL,
  PRIMARY KEY (`cart_id`),
  KEY `user_id` (`user_id`,`goods_id`,`buy_num`),
  KEY `add_time` (`add_time`,`update_time`),
  KEY `in_spec_goods_id` (`in_spec_goods_id`),
  KEY `in_wholesale_id` (`in_wholesale_id`),
  KEY `buy_now` (`buy_now`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='购物车表';

DROP TABLE IF EXISTS `dbshop_cms`;
CREATE TABLE IF NOT EXISTS `dbshop_cms` (
  `cms_id` int(11) NOT NULL AUTO_INCREMENT,
  `cms_class_id` int(11) NOT NULL,
  `cms_writer` varchar(100) DEFAULT NULL,
  `cms_url` varchar(300) DEFAULT NULL,
  `cms_title` varchar(200) NOT NULL,
  `cms_body` longtext,
  `cms_extend_title` varchar(200) DEFAULT NULL,
  `cms_keywords` varchar(200) DEFAULT NULL,
  `cms_description` varchar(500) DEFAULT NULL,
  `cms_state` tinyint(1) NOT NULL DEFAULT '1',
  `cms_sort` int(11) NOT NULL DEFAULT '255',
  `cms_add_time` int(10) NOT NULL,
  PRIMARY KEY (`cms_id`),
  KEY `cms_class_id` (`cms_class_id`,`cms_state`,`cms_sort`,`cms_add_time`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='文章表';

DROP TABLE IF EXISTS `dbshop_cms_class`;
CREATE TABLE IF NOT EXISTS `dbshop_cms_class` (
  `cms_class_id` int(11) NOT NULL AUTO_INCREMENT,
  `cms_class_top_id` int(11) NOT NULL DEFAULT '0',
  `cms_class_name` varchar(200) NOT NULL,
  `cms_class_state` tinyint(1) NOT NULL DEFAULT '1',
  `cms_class_extend_name` varchar(200) DEFAULT NULL,
  `cms_class_keywords` varchar(200) DEFAULT NULL,
  `cms_class_description` varchar(500) DEFAULT NULL,
  `cms_class_sort` int(11) NOT NULL DEFAULT '255',
  `index_news` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`cms_class_id`),
  KEY `cms_class_top_id` (`cms_class_top_id`,`cms_class_state`,`cms_class_sort`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='文章分类';

DROP TABLE IF EXISTS `dbshop_coupon`;
CREATE TABLE IF NOT EXISTS `dbshop_coupon` (
  `coupon_id` int(11) NOT NULL AUTO_INCREMENT,
  `coupon_title` varchar(150) NOT NULL,
  `coupon_info` varchar(300) NOT NULL,
  `coupon_start_time` int(10) NOT NULL DEFAULT '0',
  `coupon_end_time` int(10) NOT NULL DEFAULT '0',
  `coupon_state` tinyint(1) NOT NULL DEFAULT '1',
  `shopping_amount` int(11) NOT NULL DEFAULT '1',
  `shopping_discount` int(11) NOT NULL DEFAULT '1',
  `get_coupon_start_time` int(10) NOT NULL DEFAULT '0',
  `get_coupon_end_time` int(10) NOT NULL DEFAULT '0',
  `get_coupon_type` varchar(50) NOT NULL,
  `get_shopping_amount` int(11) NOT NULL DEFAULT '1',
  `user_get_frequency` int(11) NOT NULL DEFAULT '1' COMMENT '优惠券可获取次数，目前用于购物满',
  `get_user_type` varchar(50) NOT NULL,
  `get_user_group` text,
  `get_goods_type` varchar(50) NOT NULL,
  `get_goods_body` text,
  PRIMARY KEY (`coupon_id`),
  KEY `coupon_state` (`coupon_state`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='优惠券表';

DROP TABLE IF EXISTS `dbshop_currency`;
CREATE TABLE IF NOT EXISTS `dbshop_currency` (
  `currency_id` int(11) NOT NULL AUTO_INCREMENT,
  `currency_name` varchar(20) NOT NULL,
  `currency_code` varchar(5) NOT NULL,
  `currency_symbol` varchar(5) DEFAULT NULL,
  `currency_decimal` tinyint(1) NOT NULL DEFAULT '2',
  `currency_rate` varchar(10) NOT NULL,
  `currency_type` tinyint(1) NOT NULL DEFAULT '0',
  `currency_state` tinyint(1) NOT NULL,
  PRIMARY KEY (`currency_id`),
  KEY `currency_name` (`currency_name`,`currency_code`,`currency_decimal`,`currency_type`,`currency_state`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

DROP TABLE IF EXISTS `dbshop_delivery`;
CREATE TABLE IF NOT EXISTS `dbshop_delivery` (
  `delivery_id` int(11) NOT NULL AUTO_INCREMENT,
  `delivery_name` varchar(200) NOT NULL,
  `delivery_name_code` varchar(30) DEFAULT NULL,
  `delivery_info` varchar(1000) DEFAULT NULL,
  `delivery_url` varchar(100) DEFAULT NULL,
  `delivery_sort` int(11) NOT NULL,
  `delivery_state` tinyint(1) NOT NULL DEFAULT '1',
  `cash_on_delivery` tinyint(1) NOT NULL DEFAULT '2',
  PRIMARY KEY (`delivery_id`),
  KEY `delivery_sort` (`delivery_sort`),
  KEY `delivery_state` (`delivery_state`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

DROP TABLE IF EXISTS `dbshop_delivery_individuation`;
CREATE TABLE IF NOT EXISTS `dbshop_delivery_individuation` (
  `indiv_id` int(11) NOT NULL AUTO_INCREMENT,
  `delivery_price` varchar(1000) NOT NULL DEFAULT '0',
  `delivery_area` text,
  PRIMARY KEY (`indiv_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

DROP TABLE IF EXISTS `dbshop_discount_rule`;
CREATE TABLE IF NOT EXISTS `dbshop_discount_rule` (
  `discount_rule_id` int(11) NOT NULL AUTO_INCREMENT,
  `discount_rule_title` varchar(150) NOT NULL,
  `discount_rule_info` varchar(500) DEFAULT NULL,
  `discount_start_time` int(10) DEFAULT '0',
  `discount_end_time` int(10) DEFAULT '0',
  `user_buy_frequency` int(11) NOT NULL DEFAULT '0',
  `discount_state` tinyint(1) NOT NULL DEFAULT '1',
  `goods_buy_type` tinyint(1) NOT NULL,
  `goods_buy_amount` int(11) DEFAULT '0',
  `buy_discount` int(11) DEFAULT '0',
  `discount_mode` tinyint(1) NOT NULL,
  `discount_user_type` varchar(30) NOT NULL,
  `discount_user_group` text,
  `discount_goods_type` varchar(30) NOT NULL,
  `discount_goods_body` text,
  PRIMARY KEY (`discount_rule_id`),
  KEY `discount_state` (`discount_state`),
  KEY `doscount_mode` (`discount_mode`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='优惠促销规则表';

DROP TABLE IF EXISTS `dbshop_goods`;
CREATE TABLE IF NOT EXISTS `dbshop_goods` (
  `goods_id` int(11) NOT NULL AUTO_INCREMENT,
  `goods_item` varchar(50) NOT NULL,
  `class_id` int(11) NOT NULL,
  `brand_id` int(11) DEFAULT '0',
  `goods_name` varchar(200) NOT NULL,
  `goods_extend_name` varchar(255) DEFAULT NULL,
  `stock_id` int(11) DEFAULT '0',
  `goods_weight` int(11) NOT NULL DEFAULT '0',
  `goods_weight_conversion` int(11) NOT NULL DEFAULT '0',
  `goods_weight_unit` varchar(20) DEFAULT NULL,
  `goods_keywords` varchar(255) DEFAULT NULL,
  `goods_description` varchar(1000) DEFAULT NULL,
  `goods_market_price` decimal(19,2) DEFAULT '0.00',
  `goods_price` decimal(19,2) NOT NULL DEFAULT '0.00',
  `goods_body` longtext,
  `virtual_sales` int(11) NOT NULL DEFAULT '0',
  `goods_state` int(1) NOT NULL DEFAULT '1',
  `goods_image_id` int(11) DEFAULT '0',
  `goods_type` int(1) NOT NULL DEFAULT '1',
  `goods_tag_str` varchar(1000) CHARACTER SET utf8 DEFAULT NULL,
  `attribute_group_id` int(11) DEFAULT '0',
  `wholesale_state` tinyint(1) NOT NULL DEFAULT '0',
  `goods_integral_buy` int(1) NOT NULL DEFAULT '0',
  `goods_user_group_price` varchar(2000) DEFAULT NULL,
  `goods_click` int(11) DEFAULT '0',
  `goods_add_time` int(10) NOT NULL,
  PRIMARY KEY (`goods_id`),
  KEY `class_id` (`class_id`,`brand_id`,`goods_state`,`goods_type`,`attribute_group_id`,`goods_add_time`),
  KEY `goods_price` (`goods_price`),
  KEY `stock_id` (`stock_id`) USING BTREE,
  KEY `goods_tag_str` (`goods_tag_str`),
  KEY `goods_click` (`goods_click`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='商品基本表';

DROP TABLE IF EXISTS `dbshop_goods_attribute`;
CREATE TABLE IF NOT EXISTS `dbshop_goods_attribute` (
  `attribute_id` int(11) NOT NULL AUTO_INCREMENT,
  `attribute_group_id` int(11) NOT NULL,
  `attribute_name` varchar(100) NOT NULL,
  `attribute_type` varchar(10) NOT NULL,
  `attribute_sort` int(11) NOT NULL DEFAULT '255',
  PRIMARY KEY (`attribute_id`),
  KEY `attribute_group_id` (`attribute_group_id`,`attribute_name`,`attribute_sort`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='商品属性表';

DROP TABLE IF EXISTS `dbshop_goods_attribute_group`;
CREATE TABLE IF NOT EXISTS `dbshop_goods_attribute_group` (
  `attribute_group_id` int(11) NOT NULL AUTO_INCREMENT,
  `attribute_group_name` varchar(100) NOT NULL,
  `attribute_group_sort` int(11) NOT NULL DEFAULT '255',
  PRIMARY KEY (`attribute_group_id`),
  KEY `attribute_group_sort` (`attribute_group_sort`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='商品属性组表';

DROP TABLE IF EXISTS `dbshop_goods_attribute_value`;
CREATE TABLE IF NOT EXISTS `dbshop_goods_attribute_value` (
  `value_id` int(11) NOT NULL AUTO_INCREMENT,
  `attribute_id` int(11) NOT NULL,
  `attribute_group_id` int(11) NOT NULL,
  `value_name` varchar(100) NOT NULL,
  `value_sort` int(11) NOT NULL DEFAULT '255',
  PRIMARY KEY (`value_id`),
  KEY `attribute_id` (`attribute_id`,`attribute_group_id`,`value_name`,`value_sort`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='商品属性值表';

DROP TABLE IF EXISTS `dbshop_goods_brand`;
CREATE TABLE IF NOT EXISTS `dbshop_goods_brand` (
  `brand_id` int(11) NOT NULL AUTO_INCREMENT,
  `brand_name` varchar(150) NOT NULL,
  `brand_logo` varchar(100) DEFAULT NULL,
  `brand_info` varchar(1000) DEFAULT NULL,
  `brand_name_extend` varchar(255) DEFAULT NULL,
  `brand_keywords` varchar(255) DEFAULT NULL,
  `brand_description` varchar(1000) DEFAULT NULL,
  `brand_sort` int(11) NOT NULL DEFAULT '255',
  PRIMARY KEY (`brand_id`),
  KEY `brand_name` (`brand_name`,`brand_sort`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='商品品牌表';

DROP TABLE IF EXISTS `dbshop_goods_brand_in_class`;
CREATE TABLE IF NOT EXISTS `dbshop_goods_brand_in_class` (
  `in_b_id` int(11) NOT NULL AUTO_INCREMENT,
  `brand_id` int(11) NOT NULL,
  `class_id` int(11) NOT NULL,
  PRIMARY KEY (`in_b_id`),
  KEY `brand_id` (`brand_id`,`class_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='品牌所在分类';

DROP TABLE IF EXISTS `dbshop_goods_class`;
CREATE TABLE IF NOT EXISTS `dbshop_goods_class` (
  `class_id` int(11) NOT NULL AUTO_INCREMENT,
  `class_top_id` int(11) NOT NULL DEFAULT '0',
  `class_name` varchar(150) NOT NULL,
  `class_path` varchar(255) DEFAULT '0',
  `class_info` varchar(4000) DEFAULT NULL,
  `class_image` varchar(100) DEFAULT NULL,
  `class_state` tinyint(1) NOT NULL DEFAULT '1',
  `class_extend` varchar(255) DEFAULT NULL,
  `class_keywords` varchar(255) DEFAULT NULL,
  `class_description` varchar(1000) DEFAULT NULL,
  `class_tag_group` text,
  `class_sort` int(11) NOT NULL DEFAULT '255',
  PRIMARY KEY (`class_id`),
  KEY `class_top_id` (`class_top_id`,`class_state`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='商品分类';

DROP TABLE IF EXISTS `dbshop_goods_common_content`;
CREATE TABLE IF NOT EXISTS `dbshop_goods_common_content` (
  `content_id` int(11) NOT NULL AUTO_INCREMENT,
  `content_title` varchar(200) NOT NULL,
  `class_id_str` text,
  `content_body` longtext,
  `content_state` tinyint(1) NOT NULL DEFAULT '1',
  `content_sort` int(11) NOT NULL DEFAULT '255',
  PRIMARY KEY (`content_id`),
  KEY `content_sort` (`content_sort`),
  KEY `content_state` (`content_state`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='商品通用内容表';

DROP TABLE IF EXISTS `dbshop_goods_consultation`;
CREATE TABLE IF NOT EXISTS `dbshop_goods_consultation` (
  `consult_id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL DEFAULT '0',
  `consult_user` varchar(100) NOT NULL,
  `consult_content` varchar(2000) NOT NULL,
  `consult_time` int(10) NOT NULL,
  `consult_show_status` tinyint(1) NOT NULL DEFAULT '2',
  `reply_content` varchar(2000) DEFAULT NULL,
  `reply_time` int(10) DEFAULT NULL,
  `reply_user` varchar(100) DEFAULT NULL,
  `goods_id` int(11) NOT NULL,
  PRIMARY KEY (`consult_id`),
  KEY `consult_time` (`consult_time`,`consult_show_status`,`reply_time`,`goods_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='商品咨询表';

DROP TABLE IF EXISTS `dbshop_goods_custom`;
CREATE TABLE IF NOT EXISTS `dbshop_goods_custom` (
  `custom_id` int(11) NOT NULL AUTO_INCREMENT,
  `goods_id` int(11) NOT NULL,
  `custom_title` varchar(50) NOT NULL,
  `custom_content` varchar(200) NOT NULL,
  `front_show` tinyint(1) NOT NULL DEFAULT '2',
  `custom_key` int(2) NOT NULL,
  PRIMARY KEY (`custom_id`),
  KEY `goods_id` (`goods_id`,`front_show`),
  KEY `custom_key` (`custom_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='商品自定义表';

DROP TABLE IF EXISTS `dbshop_goods_discount`;
CREATE TABLE IF NOT EXISTS `dbshop_goods_discount` (
  `discount_id` int(11) NOT NULL AUTO_INCREMENT,
  `goods_id` int(11) NOT NULL,
  `discount_price` decimal(19,2) DEFAULT '0.00',
  `discount_start_time` int(10) DEFAULT '0',
  `discount_end_time` int(10) DEFAULT '0',
  `discount_user_group_type` varchar(20) NOT NULL,
  `discount_user_group` varchar(2000) DEFAULT NULL,
  PRIMARY KEY (`discount_id`),
  KEY `goods_id` (`goods_id`,`discount_price`,`discount_start_time`,`discount_end_time`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='商品价格优惠表';

DROP TABLE IF EXISTS `dbshop_goods_group_price`;
CREATE TABLE IF NOT EXISTS `dbshop_goods_group_price` (
  `goods_group_price_id` int(11) NOT NULL AUTO_INCREMENT,
  `user_group_price` decimal(19,2) DEFAULT '0.00',
  `user_group_id` int(11) NOT NULL,
  `goods_id` int(11) NOT NULL,
  PRIMARY KEY (`goods_group_price_id`),
  KEY `user_group_price` (`user_group_price`),
  KEY `user_group_id` (`user_group_id`,`goods_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='商品会员组价格表（冗余表）';

DROP TABLE IF EXISTS `dbshop_goods_image`;
CREATE TABLE IF NOT EXISTS `dbshop_goods_image` (
  `goods_image_id` int(11) NOT NULL AUTO_INCREMENT,
  `goods_id` int(11) NOT NULL,
  `goods_thumbnail_image` varchar(200) DEFAULT NULL,
  `goods_image` varchar(200) DEFAULT NULL,
  `image_slide` int(1) NOT NULL DEFAULT '0',
  `image_code` varchar(50) CHARACTER SET utf8 DEFAULT NULL,
  `image_sort` int(11) NOT NULL DEFAULT '255',
  PRIMARY KEY (`goods_image_id`),
  KEY `goods_id` (`goods_id`,`image_sort`,`image_slide`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='商品图片';

DROP TABLE IF EXISTS `dbshop_goods_in_attribute`;
CREATE TABLE IF NOT EXISTS `dbshop_goods_in_attribute` (
  `in_attribute_id` int(11) NOT NULL AUTO_INCREMENT,
  `goods_id` int(11) NOT NULL,
  `attribute_id` int(11) NOT NULL,
  `attribute_body` varchar(2000) DEFAULT NULL,
  PRIMARY KEY (`in_attribute_id`),
  KEY `goods_id` (`goods_id`,`attribute_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

DROP TABLE IF EXISTS `dbshop_goods_in_class`;
CREATE TABLE IF NOT EXISTS `dbshop_goods_in_class` (
  `in_id` int(11) NOT NULL AUTO_INCREMENT,
  `goods_id` int(11) NOT NULL,
  `class_id` int(11) NOT NULL,
  `class_goods_sort` int(11) DEFAULT '255',
  `class_goods_recommend` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`in_id`),
  KEY `goods_id` (`goods_id`,`class_id`,`class_goods_sort`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

DROP TABLE IF EXISTS `dbshop_goods_in_spec_goods`;
CREATE TABLE IF NOT EXISTS `dbshop_goods_in_spec_goods` (
  `in_spec_goods_id` int(11) NOT NULL AUTO_INCREMENT,
  `spec_tag_id` varchar(1000) NOT NULL,
  `tag_id_str` varchar(100) DEFAULT NULL,
  `spec_goods_price` decimal(19,2) NOT NULL DEFAULT '0.00',
  `spec_goods_stock` int(11) NOT NULL DEFAULT '1',
  `spec_goods_item` varchar(50) NOT NULL,
  `spec_goods_weight` int(11) NOT NULL DEFAULT '0',
  `spec_goods_user_group_price` varchar(2000) DEFAULT NULL,
  `goods_id` int(11) NOT NULL,
  PRIMARY KEY (`in_spec_goods_id`),
  KEY `spec_goods_price` (`spec_goods_price`,`goods_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

DROP TABLE IF EXISTS `dbshop_goods_in_spec_goods_group_price`;
CREATE TABLE IF NOT EXISTS `dbshop_goods_in_spec_goods_group_price` (
  `spec_goods_group_price_id` int(11) NOT NULL AUTO_INCREMENT,
  `user_group_price` decimal(19,2) DEFAULT '0.00',
  `user_group_id` int(11) NOT NULL,
  `in_spec_goods_id` int(11) NOT NULL,
  `goods_id` int(11) NOT NULL,
  PRIMARY KEY (`spec_goods_group_price_id`),
  KEY `user_group_price` (`user_group_price`),
  KEY `user_group_id` (`user_group_id`,`in_spec_goods_id`,`goods_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='商品规格商品会员组价格表（冗余表）';

DROP TABLE IF EXISTS `dbshop_goods_in_spec_group_tag`;
CREATE TABLE IF NOT EXISTS `dbshop_goods_in_spec_group_tag` (
  `in_group_tag_id` int(11) NOT NULL AUTO_INCREMENT,
  `goods_id` int(11) NOT NULL,
  `group_id` int(11) NOT NULL,
  `selected_tag_id` varchar(1000) DEFAULT NULL,
  `group_image` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`in_group_tag_id`),
  KEY `goods_id` (`goods_id`,`group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

DROP TABLE IF EXISTS `dbshop_goods_in_spec_image`;
CREATE TABLE IF NOT EXISTS `dbshop_goods_in_spec_image` (
  `in_spec_image_id` int(11) NOT NULL AUTO_INCREMENT,
  `tag_id` int(11) NOT NULL,
  `goods_id` int(11) NOT NULL,
  `goods_image_id` int(11) NOT NULL,
  PRIMARY KEY (`in_spec_image_id`),
  KEY `tag_id` (`tag_id`,`goods_id`,`goods_image_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

DROP TABLE IF EXISTS `dbshop_goods_in_tag`;
CREATE TABLE IF NOT EXISTS `dbshop_goods_in_tag` (
  `in_tag_id` int(11) NOT NULL AUTO_INCREMENT,
  `tag_id` int(11) NOT NULL,
  `goods_id` int(11) NOT NULL,
  `tag_goods_sort` int(11) NOT NULL DEFAULT '255',
  PRIMARY KEY (`in_tag_id`),
  KEY `tag_id` (`tag_id`,`goods_id`,`tag_goods_sort`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

DROP TABLE IF EXISTS `dbshop_goods_in_wholesale`;
CREATE TABLE IF NOT EXISTS `dbshop_goods_in_wholesale` (
  `in_wholesale_id` int(11) NOT NULL AUTO_INCREMENT,
  `goods_id` int(11) NOT NULL,
  `wholesale_start_num` int(11) NOT NULL DEFAULT '0',
  `wholesale_end_num` int(11) NOT NULL DEFAULT '0',
  `wholesale_price` decimal(19,2) NOT NULL,
  `wholesale_key` int(2) NOT NULL,
  PRIMARY KEY (`in_wholesale_id`),
  KEY `goods_id` (`goods_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

DROP TABLE IF EXISTS `dbshop_goods_sales_record`;
CREATE TABLE IF NOT EXISTS `dbshop_goods_sales_record` (
  `sales_record_id` int(11) NOT NULL AUTO_INCREMENT,
  `goods_id` int(11) NOT NULL,
  `goods_sales_num` int(11) DEFAULT '0',
  PRIMARY KEY (`sales_record_id`),
  KEY `goods_id` (`goods_id`,`goods_sales_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='商品销量表';

DROP TABLE IF EXISTS `dbshop_goods_spec_tag`;
CREATE TABLE IF NOT EXISTS `dbshop_goods_spec_tag` (
  `spec_tag_id` int(11) NOT NULL AUTO_INCREMENT,
  `spec_tag_name` varchar(100) NOT NULL,
  `spec_tag_code` varchar(50) NOT NULL,
  `spec_tag_sort` int(11) NOT NULL DEFAULT '255',
  `template_code` varchar(50) NOT NULL,
  PRIMARY KEY (`spec_tag_id`),
  KEY `spec_tag_sort` (`spec_tag_sort`,`template_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='特定商品标签';

DROP TABLE IF EXISTS `dbshop_goods_spec_tag_goods`;
CREATE TABLE IF NOT EXISTS `dbshop_goods_spec_tag_goods` (
  `spec_tag_goods_id` int(11) NOT NULL AUTO_INCREMENT,
  `spec_tag_id` int(11) NOT NULL,
  `goods_id` int(11) NOT NULL,
  `spec_tag_goods_sort` int(11) NOT NULL DEFAULT '255',
  `spec_tag_code` varchar(50) NOT NULL,
  `template_code` varchar(50) NOT NULL,
  PRIMARY KEY (`spec_tag_goods_id`),
  KEY `spec_tag_id` (`spec_tag_id`,`goods_id`,`spec_tag_goods_sort`,`spec_tag_code`,`template_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='特定标签商品';

DROP TABLE IF EXISTS `dbshop_goods_stock`;
CREATE TABLE IF NOT EXISTS `dbshop_goods_stock` (
  `stock_id` int(11) NOT NULL AUTO_INCREMENT,
  `goods_id` int(11) NOT NULL,
  `stock_num` int(11) NOT NULL DEFAULT '1',
  `stock_show` varchar(30) DEFAULT NULL,
  `stock_show_state` tinyint(1) NOT NULL DEFAULT '1',
  `stock_out_set_num` int(11) NOT NULL DEFAULT '0',
  `stock_out_show` varchar(30) DEFAULT NULL,
  `cart_buy_min_num` int(11) NOT NULL DEFAULT '0',
  `cart_buy_max_num` int(11) NOT NULL DEFAULT '0',
  `person_buy_max` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`stock_id`),
  KEY `goods_id` (`goods_id`,`stock_num`,`stock_out_set_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='商品库存与购买设置表';

DROP TABLE IF EXISTS `dbshop_goods_tag`;
CREATE TABLE IF NOT EXISTS `dbshop_goods_tag` (
  `tag_id` int(11) NOT NULL AUTO_INCREMENT,
  `tag_name` varchar(100) NOT NULL,
  `tag_group_id` int(11) NOT NULL DEFAULT '0',
  `tag_str` varchar(50) DEFAULT NULL,
  `tag_sort` int(11) NOT NULL DEFAULT '255',
  PRIMARY KEY (`tag_id`),
  KEY `tag_name` (`tag_name`,`tag_sort`),
  KEY `tag_group_id` (`tag_group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='商品标签表';

DROP TABLE IF EXISTS `dbshop_goods_tag_group`;
CREATE TABLE IF NOT EXISTS `dbshop_goods_tag_group` (
  `tag_group_id` int(11) NOT NULL AUTO_INCREMENT,
  `tag_group_name` varchar(100) NOT NULL,
  `tag_group_mark` varchar(50) DEFAULT NULL,
  `is_goods_spec` tinyint(1) NOT NULL DEFAULT '0',
  `tag_group_sort` int(11) NOT NULL DEFAULT '255',
  PRIMARY KEY (`tag_group_id`),
  KEY `tag_group_name` (`tag_group_name`,`is_goods_spec`,`tag_group_sort`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='商品标签组表';

DROP TABLE IF EXISTS `dbshop_goods_virtual`;
CREATE TABLE IF NOT EXISTS `dbshop_goods_virtual` (
  `virtual_goods_id` int(11) NOT NULL AUTO_INCREMENT,
  `virtual_goods_account` varchar(150) NOT NULL,
  `virtual_goods_account_type` int(1) NOT NULL DEFAULT '1',
  `virtual_goods_password` varchar(150) NOT NULL,
  `virtual_goods_password_type` int(1) NOT NULL DEFAULT '1',
  `virtual_goods_end_time` int(10) DEFAULT '0',
  `virtual_goods_state` int(1) NOT NULL DEFAULT '1',
  `order_sn` varchar(50) DEFAULT NULL,
  `order_id` int(11) DEFAULT NULL,
  `goods_id` int(11) DEFAULT NULL,
  `user_id` int(11) DEFAULT '0',
  `user_name` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`virtual_goods_id`),
  KEY `order_id` (`order_id`,`goods_id`,`user_id`),
  KEY `virtual_goods_end_time` (`virtual_goods_end_time`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

DROP TABLE IF EXISTS `dbshop_integral_log`;
CREATE TABLE IF NOT EXISTS `dbshop_integral_log` (
  `integral_log_id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `user_name` varchar(100) NOT NULL,
  `integral_log_info` varchar(500) NOT NULL,
  `change_integral_num` int(11) NOT NULL,
  `integral_num` int(11) NOT NULL,
  `integral_type_id` int(11) NOT NULL,
  `integral_log_time` int(10) NOT NULL,
  `admin_id` int(11) DEFAULT '0',
  `admin_name` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`integral_log_id`),
  KEY `user_id` (`user_id`,`user_name`,`integral_type_id`,`integral_log_time`),
  KEY `admin_id` (`admin_id`,`admin_name`),
  KEY `change_integral_num` (`change_integral_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='积分历史记录';

DROP TABLE IF EXISTS `dbshop_integral_rule`;
CREATE TABLE IF NOT EXISTS `dbshop_integral_rule` (
  `integral_rule_id` int(11) NOT NULL AUTO_INCREMENT,
  `integral_rule_title` varchar(200) NOT NULL,
  `integral_rule_info` varchar(500) NOT NULL,
  `integral_rule_start_time` int(10) DEFAULT '0',
  `integral_rule_end_time` int(10) DEFAULT '0',
  `integral_rule_state` tinyint(1) DEFAULT '1',
  `integral_rule_type` varchar(50) NOT NULL,
  `integral_rule_body` text,
  `integral_type_id` tinyint(1) NOT NULL,
  `integral_num` int(11) NOT NULL,
  `integral_rule_user_type` varchar(30) NOT NULL,
  `integral_rule_user_body` text,
  `integral_rule_goods_type` varchar(30) NOT NULL,
  `integral_rule_goods_body` text,
  PRIMARY KEY (`integral_rule_id`),
  KEY `integral_rule_state` (`integral_rule_state`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='积分规则表';

DROP TABLE IF EXISTS `dbshop_integral_type`;
CREATE TABLE IF NOT EXISTS `dbshop_integral_type` (
  `integral_type_id` int(11) NOT NULL AUTO_INCREMENT,
  `integral_type_name` varchar(100) NOT NULL,
  `integral_default_num` int(11) NOT NULL DEFAULT '0',
  `integral_type_mark` varchar(30) NOT NULL,
  `integral_currency_con` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`integral_type_id`),
  KEY `integral_type_name` (`integral_type_name`),
  KEY `integral_currency_con` (`integral_currency_con`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='积分类型表';

DROP TABLE IF EXISTS `dbshop_navigation`;
CREATE TABLE IF NOT EXISTS `dbshop_navigation` (
  `navigation_id` int(11) NOT NULL AUTO_INCREMENT,
  `navigation_title` varchar(200) NOT NULL,
  `navigation_url` varchar(500) DEFAULT NULL,
  `navigation_place` tinyint(1) NOT NULL,
  `goods_class_id` int(11) DEFAULT '0',
  `new_window` tinyint(1) DEFAULT '0',
  `navigation_sort` int(11) NOT NULL DEFAULT '255',
  PRIMARY KEY (`navigation_id`),
  KEY `navigation_place` (`navigation_place`),
  KEY `navigation_sort` (`navigation_sort`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='前台导航表';

DROP TABLE IF EXISTS `dbshop_operlog`;
CREATE TABLE IF NOT EXISTS `dbshop_operlog` (
  `log_id` int(11) NOT NULL AUTO_INCREMENT,
  `log_oper_user` varchar(100) NOT NULL,
  `log_oper_user_group` varchar(100) NOT NULL,
  `log_time` int(10) NOT NULL,
  `log_ip` varchar(50) NOT NULL,
  `log_body` varchar(2000) DEFAULT NULL,
  PRIMARY KEY (`log_id`),
  KEY `dberp_oper_log_index` (`log_oper_user`,`log_oper_user_group`,`log_time`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='操作记录';

DROP TABLE IF EXISTS `dbshop_order`;
CREATE TABLE IF NOT EXISTS `dbshop_order` (
  `order_id` int(11) NOT NULL AUTO_INCREMENT,
  `order_sn` varchar(50) NOT NULL,
  `out_trade_no` varchar(50) DEFAULT NULL,
  `order_amount` decimal(19,2) NOT NULL DEFAULT '0.00',
  `base_order_amount` decimal(19,2) NOT NULL DEFAULT '0.00',
  `goods_amount` decimal(19,2) NOT NULL DEFAULT '0.00',
  `order_status` tinyint(2) NOT NULL DEFAULT '10',
  `payment_type` varchar(30) NOT NULL,
  `payment_code` varchar(30) DEFAULT NULL,
  `payment_name` varchar(100) DEFAULT NULL,
  `payment_certification` varchar(500) DEFAULT NULL,
  `payment_finish_time` int(10) DEFAULT NULL,
  `delivery_type` varchar(30) NOT NULL,
  `delivery_mode` tinyint(1) NOT NULL DEFAULT '0',
  `delivery_id` int(11) DEFAULT '0',
  `delivery_name` varchar(200) DEFAULT NULL,
  `express_number` varchar(50) DEFAULT NULL,
  `shipping_fee` decimal(19,2) DEFAULT '0.00',
  `express_time` int(10) DEFAULT NULL,
  `currency_code` varchar(5) NOT NULL,
  `currency_symbol` varchar(5) NOT NULL,
  `order_weight_amount` int(11) DEFAULT '0',
  `order_return_type` tinyint(1) DEFAULT '0',
  `order_message` varchar(500) DEFAULT NULL,
  `user_id` int(11) NOT NULL,
  `user_name` varchar(100) NOT NULL,
  `order_add_time` int(10) NOT NULL,
  `order_finish_time` int(10) DEFAULT NULL,
  PRIMARY KEY (`order_id`),
  KEY `order_sn` (`order_sn`,`payment_type`,`payment_code`,`user_name`),
  KEY `order_status` (`order_status`,`delivery_id`,`user_id`),
  KEY `payment_finish_time` (`payment_finish_time`,`order_add_time`,`order_finish_time`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='订单表';

DROP TABLE IF EXISTS `dbshop_order_change_amount`;
CREATE TABLE IF NOT EXISTS `dbshop_order_change_amount` (
  `order_change_id` int(11) NOT NULL AUTO_INCREMENT,
  `order_amount` decimal(19,2) NOT NULL,
  `order_original_amount` decimal(19,2) NOT NULL,
  `order_change_type` varchar(1) NOT NULL,
  `order_change_num` decimal(19,2) NOT NULL,
  `order_change_time` int(10) NOT NULL,
  `operate_user` varchar(100) NOT NULL,
  `order_change_info` varchar(500) DEFAULT NULL,
  `order_id` int(11) NOT NULL,
  PRIMARY KEY (`order_change_id`),
  KEY `order_amount` (`order_amount`,`order_original_amount`,`order_change_num`),
  KEY `order_change_time` (`order_change_time`),
  KEY `order_id` (`order_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='订单金额修改历史';

DROP TABLE IF EXISTS `dbshop_order_delivery_address`;
CREATE TABLE IF NOT EXISTS `dbshop_order_delivery_address` (
  `order_address_id` int(11) NOT NULL AUTO_INCREMENT,
  `true_name` varchar(100) NOT NULL,
  `region_value` varchar(255) NOT NULL,
  `address_info` varchar(500) NOT NULL,
  `post_code` varchar(20) DEFAULT NULL,
  `area_code` varchar(10) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `delivery_time_info` varchar(300) DEFAULT NULL,
  `order_id` int(11) NOT NULL,
  PRIMARY KEY (`order_address_id`),
  KEY `order_id` (`order_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='订单收货地址';

DROP TABLE IF EXISTS `dbshop_order_discount_record`;
CREATE TABLE IF NOT EXISTS `dbshop_order_discount_record` (
  `record_id` int(11) NOT NULL AUTO_INCREMENT,
  `discount_cost` decimal(19,2) NOT NULL DEFAULT '0.00',
  `discount_type` varchar(30) NOT NULL,
  `discount_info` varchar(200) DEFAULT NULL,
  `order_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `id` int(11) NOT NULL,
  PRIMARY KEY (`record_id`),
  KEY `discount_type` (`discount_type`),
  KEY `order_id` (`order_id`),
  KEY `user_id` (`user_id`),
  KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='订单优惠记录信息';

DROP TABLE IF EXISTS `dbshop_order_goods`;
CREATE TABLE IF NOT EXISTS `dbshop_order_goods` (
  `order_goods_id` int(11) NOT NULL AUTO_INCREMENT,
  `order_id` int(11) NOT NULL,
  `goods_id` int(11) NOT NULL,
  `goods_name` varchar(200) NOT NULL,
  `goods_item` varchar(50) NOT NULL,
  `goods_price` decimal(19,2) DEFAULT '0.00',
  `goods_image` varchar(200) DEFAULT NULL,
  `in_spec_goods_str` varchar(500) DEFAULT NULL,
  `in_spec_goods_id` int(11) DEFAULT '0',
  `goods_type` tinyint(1) NOT NULL DEFAULT '1',
  `buy_num` int(11) NOT NULL,
  `base_goods_amount` decimal(19,2) NOT NULL DEFAULT '0.00',
  `goods_amount` decimal(19,2) NOT NULL,
  `goods_weight_amount` int(11) DEFAULT '0',
  `delivery_id` int(11) DEFAULT '0',
  `delivery_name` varchar(200) DEFAULT NULL,
  `goods_status` tinyint(2) DEFAULT '0',
  `express_number` varchar(50) DEFAULT NULL,
  `express_time` int(10) DEFAULT NULL,
  `evaluation_status` tinyint(1) NOT NULL DEFAULT '0',
  `user_id` int(11) NOT NULL,
  PRIMARY KEY (`order_goods_id`),
  KEY `order_id` (`order_id`,`goods_id`,`goods_type`,`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='订单商品表';

DROP TABLE IF EXISTS `dbshop_order_goods_evaluation`;
CREATE TABLE IF NOT EXISTS `dbshop_order_goods_evaluation` (
  `evaluation_id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `user_name` varchar(100) NOT NULL,
  `evaluation_body` varchar(2000) NOT NULL,
  `evaluation_star` tinyint(1) NOT NULL DEFAULT '0',
  `evaluation_time` int(10) NOT NULL,
  `evaluation_show_state` tinyint(1) NOT NULL DEFAULT '0',
  `add_evaluation_body` varchar(2000) DEFAULT NULL,
  `add_evaluation_time` int(10) DEFAULT NULL,
  `reply_body` varchar(2000) DEFAULT NULL,
  `reply_time` int(10) DEFAULT NULL,
  `reply_user` varchar(100) DEFAULT NULL,
  `goods_id` int(11) NOT NULL,
  `order_goods_id` int(11) NOT NULL,
  PRIMARY KEY (`evaluation_id`),
  KEY `user_id` (`user_id`),
  KEY `evaluation_time` (`evaluation_time`),
  KEY `goods_id` (`goods_id`),
  KEY `order_goods_id` (`order_goods_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='订单商品评价';

DROP TABLE IF EXISTS `dbshop_order_goods_evaluation_base`;
CREATE TABLE IF NOT EXISTS `dbshop_order_goods_evaluation_base` (
  `evaluation_base_id` int(11) NOT NULL AUTO_INCREMENT,
  `goods_id` int(11) NOT NULL,
  `evaluation_last_user` varchar(100) NOT NULL,
  `evaluation_last_time` int(10) NOT NULL,
  `evaluation_count` int(11) NOT NULL,
  PRIMARY KEY (`evaluation_base_id`),
  KEY `goods_id` (`goods_id`),
  KEY `evaluation_last_user` (`evaluation_last_user`),
  KEY `evaluation_last_time` (`evaluation_last_time`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='商品评价基本表';

DROP TABLE IF EXISTS `dbshop_order_goods_return`;
CREATE TABLE IF NOT EXISTS `dbshop_order_goods_return` (
  `return_id` int(11) NOT NULL AUTO_INCREMENT,
  `order_id` int(11) NOT NULL,
  `order_sn` varchar(50) NOT NULL,
  `user_id` int(11) NOT NULL,
  `user_name` varchar(100) NOT NULL,
  `order_goods_id` int(11) NOT NULL,
  `return_type` tinyint(1) NOT NULL,
  `return_reason` varchar(200) NOT NULL,
  `return_amount` decimal(10,2) NOT NULL DEFAULT '0.00',
  `refund_pay_type` varchar(20) DEFAULT NULL,
  `refund_pay_name` varchar(200) DEFAULT NULL,
  `refund_user` varchar(100) DEFAULT NULL,
  `refund_account` varchar(100) DEFAULT NULL,
  `return_info` varchar(1000) DEFAULT NULL,
  `return_state` tinyint(1) NOT NULL,
  `add_time` int(10) NOT NULL,
  `review_info` varchar(500) DEFAULT NULL,
  `review_time` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`return_id`),
  KEY `order_id` (`order_id`,`order_goods_id`),
  KEY `user_id` (`user_id`),
  KEY `return_state` (`return_state`),
  KEY `order_sn` (`order_sn`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='退款退货换货表';

DROP TABLE IF EXISTS `dbshop_order_self_location`;
CREATE TABLE IF NOT EXISTS `dbshop_order_self_location` (
  `order_location_id` int(11) NOT NULL AUTO_INCREMENT,
  `location_id` int(11) NOT NULL,
  `order_id` int(11) NOT NULL,
  `location_name` varchar(200) NOT NULL,
  `region_info` varchar(150) DEFAULT NULL,
  `location_address` varchar(200) NOT NULL,
  `location_geo_coding` varchar(50) DEFAULT NULL,
  `location_phone` varchar(30) NOT NULL,
  `location_user` varchar(200) NOT NULL,
  `location_business_hours` varchar(200) DEFAULT NULL,
  `take_code` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`order_location_id`),
  KEY `order_id` (`order_id`),
  KEY `take_code` (`take_code`),
  KEY `location_id` (`location_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='订单自提点表';

DROP TABLE IF EXISTS `dbshop_order_status`;
CREATE TABLE IF NOT EXISTS `dbshop_order_status` (
  `status_id` int(11) NOT NULL AUTO_INCREMENT,
  `order_status` tinyint(2) NOT NULL DEFAULT '0',
  `operate_user` varchar(100) NOT NULL,
  `order_id` int(11) NOT NULL,
  `status_info` varchar(255) DEFAULT NULL,
  `status_time` int(10) NOT NULL,
  PRIMARY KEY (`status_id`),
  KEY `order_status` (`order_status`,`order_id`,`status_time`),
  KEY `operate_user` (`operate_user`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='订单状态表';

DROP TABLE IF EXISTS `dbshop_phone_area_code`;
CREATE TABLE IF NOT EXISTS `dbshop_phone_area_code` (
  `area_id` int(11) NOT NULL AUTO_INCREMENT,
  `area_name` varchar(100) NOT NULL,
  `area_code` varchar(10) NOT NULL,
  `area_phone_code` varchar(10) NOT NULL,
  `area_sort` int(11) NOT NULL DEFAULT '255',
  `area_state` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`area_id`),
  KEY `area_name` (`area_name`,`area_code`),
  KEY `area_state` (`area_state`,`area_sort`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='国际电话区号';

DROP TABLE IF EXISTS `dbshop_recharge_code`;
CREATE TABLE IF NOT EXISTS `dbshop_recharge_code` (
  `code_id` int(11) NOT NULL AUTO_INCREMENT,
  `code_rule_id` int(11) NOT NULL,
  `code_money` decimal(19,2) NOT NULL DEFAULT '0.00',
  `code_str` varchar(100) NOT NULL,
  `user_id` int(11) NOT NULL DEFAULT '0',
  `user_name` varchar(100) DEFAULT NULL,
  `code_recharge_time` int(10) NOT NULL DEFAULT '0',
  `code_create_time` int(10) NOT NULL,
  PRIMARY KEY (`code_id`),
  KEY `code_rule_id` (`code_rule_id`),
  KEY `user_id` (`user_id`),
  KEY `code_recharge_time` (`code_recharge_time`,`code_create_time`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='充值码生成表';

DROP TABLE IF EXISTS `dbshop_recharge_code_rule`;
CREATE TABLE IF NOT EXISTS `dbshop_recharge_code_rule` (
  `code_rule_id` int(11) NOT NULL AUTO_INCREMENT,
  `code_rule_title` varchar(200) NOT NULL,
  `code_one_money` decimal(19,2) NOT NULL DEFAULT '0.00',
  `code_num` int(11) NOT NULL DEFAULT '0',
  `code_start_time` int(10) DEFAULT NULL,
  `code_end_time` int(10) DEFAULT NULL,
  `code_rule_state` tinyint(1) NOT NULL DEFAULT '0',
  `code_rule_add_time` int(10) NOT NULL,
  PRIMARY KEY (`code_rule_id`),
  KEY `code_rule_add_time` (`code_rule_add_time`),
  KEY `code_rule_state` (`code_rule_state`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='充值码规则';

DROP TABLE IF EXISTS `dbshop_region`;
CREATE TABLE IF NOT EXISTS `dbshop_region` (
  `region_id` int(11) NOT NULL AUTO_INCREMENT,
  `region_name` varchar(50) NOT NULL,
  `region_top_id` int(11) NOT NULL DEFAULT '0',
  `region_sort` int(11) NOT NULL DEFAULT '255',
  `region_path` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`region_id`),
  KEY `dbshop_region_index` (`region_name`,`region_sort`,`region_top_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='地区数据表';

DROP TABLE IF EXISTS `dbshop_self_location`;
CREATE TABLE IF NOT EXISTS `dbshop_self_location` (
  `location_id` int(11) NOT NULL AUTO_INCREMENT,
  `location_name` varchar(200) NOT NULL,
  `region_id` int(11) DEFAULT '0',
  `region_info` varchar(150) DEFAULT NULL,
  `location_address` varchar(200) NOT NULL,
  `location_geo_coding` varchar(50) DEFAULT NULL,
  `location_phone` varchar(30) NOT NULL,
  `location_user` varchar(100) NOT NULL,
  `location_business_hours` varchar(200) DEFAULT NULL,
  `location_sort` int(11) NOT NULL DEFAULT '255',
  `location_state` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`location_id`),
  KEY `region_id` (`region_id`,`location_user`,`location_state`),
  KEY `local_sort` (`location_sort`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='自提点数据表';

DROP TABLE IF EXISTS `dbshop_single_cms`;
CREATE TABLE IF NOT EXISTS `dbshop_single_cms` (
  `single_cms_id` int(11) NOT NULL AUTO_INCREMENT,
  `single_cms_title` varchar(200) NOT NULL,
  `single_cms_body` longtext,
  `single_cms_extend_title` varchar(200) DEFAULT NULL,
  `single_cms_keywords` varchar(200) DEFAULT NULL,
  `single_cms_description` varchar(500) CHARACTER SET utf8 DEFAULT NULL,
  `single_cms_sort` int(11) NOT NULL DEFAULT '255',
  `single_tag` varchar(50) DEFAULT NULL,
  `template_code` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`single_cms_id`),
  KEY `single_cms_sort` (`single_cms_sort`,`single_tag`,`template_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='单页文章表';

DROP TABLE IF EXISTS `dbshop_system`;
CREATE TABLE IF NOT EXISTS `dbshop_system` (
  `sys_id` int(11) NOT NULL AUTO_INCREMENT,
  `sys_name` varchar(30) NOT NULL,
  `sys_body` text,
  `sys_type` varchar(15) NOT NULL,
  PRIMARY KEY (`sys_id`),
  KEY `dberp_sys_index` (`sys_name`,`sys_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='系统信息表';

DROP TABLE IF EXISTS `dbshop_template`;
CREATE TABLE IF NOT EXISTS `dbshop_template` (
  `template_id` int(11) NOT NULL AUTO_INCREMENT,
  `template_name` varchar(50) NOT NULL,
  `template_code` varchar(50) NOT NULL,
  `template_language` varchar(200) DEFAULT NULL,
  `template_info` varchar(500) DEFAULT NULL,
  `template_version_number` bigint(12) NOT NULL,
  `template_type` varchar(15) NOT NULL,
  PRIMARY KEY (`template_id`),
  KEY `template_code` (`template_code`,`template_version_number`,`template_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='模板数据表';

DROP TABLE IF EXISTS `dbshop_user`;
CREATE TABLE IF NOT EXISTS `dbshop_user` (
  `user_id` int(11) NOT NULL AUTO_INCREMENT,
  `user_group_id` int(11) NOT NULL,
  `user_name` varchar(100) NOT NULL,
  `user_avatar` varchar(100) DEFAULT NULL,
  `user_password` varchar(72) NOT NULL,
  `pay_password` varchar(72) DEFAULT NULL,
  `user_email` varchar(50) DEFAULT NULL,
  `user_sex` tinyint(1) NOT NULL DEFAULT '3',
  `user_birthday` varchar(10) DEFAULT NULL,
  `area_code` varchar(10) DEFAULT NULL COMMENT '国际电话地区编码',
  `user_phone` varchar(20) DEFAULT NULL,
  `user_status` tinyint(1) NOT NULL DEFAULT '1',
  `user_add_time` int(10) NOT NULL,
  `user_money` decimal(19,2) DEFAULT '0.00',
  `integral_type1_num` int(11) DEFAULT '0',
  `integral_type2_num` int(11) DEFAULT '0',
  `user_email_audit_code` varchar(50) DEFAULT NULL,
  `user_forgot_password_code` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`user_id`),
  KEY `user_group_id` (`user_group_id`,`user_name`,`user_email`,`user_sex`,`user_phone`,`user_status`,`user_add_time`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='会员表';

DROP TABLE IF EXISTS `dbshop_user_address`;
CREATE TABLE IF NOT EXISTS `dbshop_user_address` (
  `address_id` int(11) NOT NULL AUTO_INCREMENT,
  `true_name` varchar(100) NOT NULL,
  `region_id` int(11) NOT NULL,
  `region_value` varchar(255) NOT NULL,
  `address_info` varchar(500) NOT NULL,
  `post_code` varchar(20) DEFAULT NULL,
  `area_code` varchar(10) NOT NULL COMMENT '国际电话区号识别',
  `phone` varchar(30) NOT NULL,
  `addr_default` tinyint(1) DEFAULT '0',
  `user_id` int(11) NOT NULL,
  PRIMARY KEY (`address_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='客户收货地址';

DROP TABLE IF EXISTS `dbshop_user_balance_log`;
CREATE TABLE IF NOT EXISTS `dbshop_user_balance_log` (
  `balance_log_id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `user_name` varchar(100) NOT NULL,
  `balance_change_type` tinyint(4) NOT NULL,
  `balance_change_num` decimal(19,2) NOT NULL DEFAULT '0.00',
  `balance_changed_amount` decimal(19,2) NOT NULL DEFAULT '0.00',
  `balance_change_time` int(10) NOT NULL,
  `balance_change_info` varchar(500) DEFAULT NULL,
  `admin_id` int(11) DEFAULT '0',
  `admin_name` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`balance_log_id`),
  KEY `user_id` (`user_id`,`user_name`,`balance_change_type`,`balance_change_time`,`admin_id`,`admin_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='客户余额记录';

DROP TABLE IF EXISTS `dbshop_user_coupon`;
CREATE TABLE IF NOT EXISTS `dbshop_user_coupon` (
  `user_coupon_id` int(11) NOT NULL AUTO_INCREMENT,
  `coupon_use_state` tinyint(1) NOT NULL DEFAULT '0',
  `user_id` int(11) NOT NULL,
  `user_name` varchar(100) NOT NULL,
  `used_order_id` int(11) NOT NULL DEFAULT '0',
  `used_order_sn` varchar(50) DEFAULT NULL,
  `used_time` int(10) NOT NULL DEFAULT '0',
  `get_order_id` int(11) NOT NULL DEFAULT '0',
  `get_order_sn` varchar(50) DEFAULT NULL,
  `get_time` int(10) NOT NULL,
  `coupon_id` int(11) NOT NULL,
  `coupon_title` varchar(150) NOT NULL,
  `coupon_info` varchar(300) NOT NULL,
  `coupon_use_start_time` int(10) NOT NULL DEFAULT '0',
  `coupon_use_end_time` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`user_coupon_id`),
  KEY `used_time` (`used_time`,`get_time`),
  KEY `coupon_id` (`coupon_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='客户获取到的优惠券';

DROP TABLE IF EXISTS `dbshop_user_goods_favorites`;
CREATE TABLE IF NOT EXISTS `dbshop_user_goods_favorites` (
  `goods_favorites_id` int(11) NOT NULL AUTO_INCREMENT,
  `goods_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `favorites_time` int(10) NOT NULL,
  PRIMARY KEY (`goods_favorites_id`),
  KEY `goods_id` (`goods_id`,`user_id`,`favorites_time`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='收藏商品表';

DROP TABLE IF EXISTS `dbshop_user_group`;
CREATE TABLE IF NOT EXISTS `dbshop_user_group` (
  `user_group_id` int(11) NOT NULL AUTO_INCREMENT,
  `user_group_name` varchar(150) NOT NULL,
  `integral_start` int(11) NOT NULL DEFAULT '0',
  `integral_end` int(11) NOT NULL DEFAULT '0',
  `integral_state` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`user_group_id`),
  KEY `integral_state` (`integral_state`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='会员组表';

DROP TABLE IF EXISTS `dbshop_user_integral_confirm`;
CREATE TABLE IF NOT EXISTS `dbshop_user_integral_confirm` (
  `confirm_id` int(11) NOT NULL AUTO_INCREMENT,
  `integral_type1_num` int(11) NOT NULL DEFAULT '0',
  `integral_type2_num` int(11) NOT NULL DEFAULT '0',
  `user_id` int(11) NOT NULL,
  `id` int(11) NOT NULL,
  `confirm_type` varchar(20) NOT NULL,
  `confirm_state` tinyint(1) NOT NULL DEFAULT '0',
  `add_time` int(10) NOT NULL,
  `confirm_time` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`confirm_id`),
  KEY `user_id` (`user_id`,`id`,`confirm_state`),
  KEY `confirm_type` (`confirm_type`),
  KEY `add_time` (`add_time`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='确认获取积分表（需要确认才可以获取的）';

DROP TABLE IF EXISTS `dbshop_user_other_login`;
CREATE TABLE IF NOT EXISTS `dbshop_user_other_login` (
  `ol_id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `open_id` varchar(100) NOT NULL,
  `union_id` varchar(100) DEFAULT NULL,
  `ol_add_time` int(10) NOT NULL,
  `login_type` varchar(30) NOT NULL,
  PRIMARY KEY (`ol_id`),
  KEY `user_id` (`user_id`),
  KEY `login_type` (`login_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='第三方登录表';

DROP TABLE IF EXISTS `dbshop_user_recharge`;
CREATE TABLE IF NOT EXISTS `dbshop_user_recharge` (
  `recharge_id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `user_name` varchar(100) NOT NULL,
  `recharge_num` decimal(19,2) NOT NULL DEFAULT '0.00',
  `currency_code` varchar(5) NOT NULL,
  `currency_rate` varchar(10) NOT NULL,
  `base_recharge_num` decimal(19,2) DEFAULT '0.00',
  `base_currency_code` varchar(5) DEFAULT NULL,
  `pay_state` tinyint(2) DEFAULT '10',
  `pay_code` varchar(30) NOT NULL,
  `pay_name` varchar(100) NOT NULL,
  `add_recharge_time` int(10) NOT NULL,
  `finish_recharge_time` int(10) DEFAULT '0',
  PRIMARY KEY (`recharge_id`),
  KEY `user_id` (`user_id`,`add_recharge_time`,`finish_recharge_time`),
  KEY `user_name` (`user_name`,`pay_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='会员充值表';

DROP TABLE IF EXISTS `dbshop_user_withdraw`;
CREATE TABLE IF NOT EXISTS `dbshop_user_withdraw` (
  `withdraw_id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `user_name` varchar(100) NOT NULL,
  `money_change_num` decimal(19,2) NOT NULL DEFAULT '0.00',
  `currency_code` varchar(10) NOT NULL,
  `bank_name` varchar(100) NOT NULL,
  `bank_account` varchar(50) NOT NULL,
  `bank_card_number` varchar(100) NOT NULL,
  `withdraw_info` varchar(500) DEFAULT NULL,
  `add_withdraw_time` int(10) NOT NULL,
  `withdraw_state` tinyint(1) NOT NULL DEFAULT '0',
  `withdraw_finish_time` int(10) DEFAULT NULL,
  `admin_id` int(11) NOT NULL,
  `admin_name` varchar(100) NOT NULL,
  PRIMARY KEY (`withdraw_id`),
  KEY `user_id` (`user_id`,`add_withdraw_time`,`withdraw_state`,`admin_id`),
  KEY `money_change_num` (`money_change_num`),
  KEY `bank_name` (`bank_name`,`bank_account`,`bank_card_number`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='会员提现表';

DROP TABLE IF EXISTS `dbshop_plugin`;
CREATE TABLE IF NOT EXISTS `dbshop_plugin` (
  `plugin_id` int(11) NOT NULL AUTO_INCREMENT,
  `plugin_name` varchar(100) NOT NULL,
  `plugin_author` varchar(100) NOT NULL,
  `plugin_author_url` varchar(200) DEFAULT NULL,
  `plugin_info` text NOT NULL,
  `plugin_version` varchar(20) NOT NULL,
  `plugin_version_num` int(11) NOT NULL,
  `plugin_code` varchar(50) NOT NULL,
  `plugin_state` tinyint(1) NOT NULL DEFAULT '0',
  `plugin_support_url` varchar(200) DEFAULT NULL,
  `plugin_admin_path` varchar(200) DEFAULT NULL,
  `plugin_update_time` date NOT NULL,
  PRIMARY KEY (`plugin_id`),
  KEY `plugin_version_num` (`plugin_version_num`),
  KEY `plugin_code` (`plugin_code`),
  KEY `plugin_state` (`plugin_state`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='插件表';

DROP TABLE IF EXISTS `dbshop_system_notice`;
CREATE TABLE IF NOT EXISTS `dbshop_system_notice` (
  `notice_id` int(11) NOT NULL AUTO_INCREMENT,
  `notice_title` varchar(100) NOT NULL,
  `notice_body` varchar(3000) NOT NULL,
  `notice_read_state` tinyint(1) NOT NULL DEFAULT '0',
  `notice_time` int(10) NOT NULL,
  `notice_type` varchar(20) NOT NULL,
  `notice_class` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`notice_id`),
  KEY `notice_read_state` (`notice_read_state`),
  KEY `notice_time` (`notice_time`),
  KEY `notice_type` (`notice_type`),
  KEY `notice_class` (`notice_class`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='后台系统通知';

DROP TABLE IF EXISTS `dbshop_express_push_receive`;
CREATE TABLE IF NOT EXISTS `dbshop_express_push_receive` (
  `receive_id` int(11) NOT NULL AUTO_INCREMENT,
  `order_id` int(11) NOT NULL,
  `com_code` varchar(50) NOT NULL,
  `com_number` varchar(80) NOT NULL,
  `receive_body` text,
  `update_time` int(10) NOT NULL,
  PRIMARY KEY (`receive_id`),
  KEY `order_id` (`order_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='配送轨迹获取推送信息';

