<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Operation;

use Admin\Data\Config;
use Operation\Controller\AdController;
use Operation\Controller\AdvanceSaleController;
use Operation\Controller\BargainController;
use Operation\Controller\BuyTogetherController;
use Operation\Controller\CouponCodeController;
use Operation\Controller\CouponController;
use Operation\Controller\DiscountController;
use Operation\Controller\Factory\AdControllerFactory;
use Operation\Controller\Factory\AdvanceSaleControllerFactory;
use Operation\Controller\Factory\BargainControllerFactory;
use Operation\Controller\Factory\BuyTogetherControllerFactory;
use Operation\Controller\Factory\CouponCodeControllerFactory;
use Operation\Controller\Factory\CouponControllerFactory;
use Operation\Controller\Factory\DiscountControllerFactory;
use Operation\Controller\Factory\GiftControllerFactory;
use Operation\Controller\Factory\GroupBuyControllerFactory;
use Operation\Controller\Factory\IndexControllerFactory;
use Operation\Controller\Factory\RechargeCodeControllerFactory;
use Operation\Controller\Factory\RepurchaseControllerFactory;
use Operation\Controller\Factory\ThemeControllerFactory;
use Operation\Controller\GiftController;
use Operation\Controller\GroupBuyController;
use Operation\Controller\IndexController;
use Doctrine\ORM\Mapping\Driver\AnnotationDriver;
use Laminas\Router\Http\Segment;
use Operation\Controller\RechargeCodeController;
use Operation\Controller\RepurchaseController;
use Operation\Controller\ThemeController;
use Operation\Event\Factory\OperationListenerFactory;
use Operation\Event\OperationListener;
use Operation\Service\AdManager;
use Operation\Service\AdSlideManager;
use Operation\Service\CouponManager;
use Operation\Service\DiscountRuleManager;
use Operation\Service\Factory\AdManagerFactory;
use Operation\Service\Factory\AdSlideManagerFactory;
use Operation\Service\Factory\CouponManagerFactory;
use Operation\Service\Factory\DiscountRuleManagerFactory;
use Operation\Service\Factory\RechargeCodeManagerFactory;
use Operation\Service\Factory\RechargeCodeRuleManagerFactory;
use Operation\Service\Factory\UserCouponManagerFactory;
use Operation\Service\RechargeCodeManager;
use Operation\Service\RechargeCodeRuleManager;
use Operation\Service\UserCouponManager;
use Operation\View\Factory\OperationHelperFactory;
use Operation\View\OperationHelper;

return [
    'router' => [
        'routes' => [
            'operation-ad' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/' . Config::ADMIN_PATH . '/operation-ad[/:action[/:id]]',
                    'defaults' => [
                        'controller' => AdController::class,
                        'action'    => 'index'
                    ]
                ]
            ],

            'operation' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/' . Config::ADMIN_PATH . '/operation[/:action[/:id]]',
                    'defaults' => [
                        'controller' => IndexController::class,
                        'action'    => 'index'
                    ]
                ]
            ],

            'operation-discount' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/' . Config::ADMIN_PATH . '/operation-discount[/:action[/:id]]',
                    'defaults' => [
                        'controller' => DiscountController::class,
                        'action'    => 'index'
                    ]
                ]
            ],

            'operation-coupon' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/' . Config::ADMIN_PATH . '/operation-coupon[/:action[/:id]]',
                    'defaults' => [
                        'controller' => CouponController::class,
                        'action'    => 'index'
                    ]
                ]
            ],

            'operation-coupon-code' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/' . Config::ADMIN_PATH . '/operation-coupon-code[/:action[/:id]]',
                    'defaults' => [
                        'controller' => CouponCodeController::class,
                        'action'    => 'index'
                    ]
                ]
            ],

            'operation-recharge-code' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/' . Config::ADMIN_PATH . '/operation-recharge-code[/:action[/:id]]',
                    'defaults' => [
                        'controller' => RechargeCodeController::class,
                        'action'    => 'index'
                    ]
                ]
            ],

            'operation-gift' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/' . Config::ADMIN_PATH . '/operation-gift[/:action[/:id]]',
                    'defaults' => [
                        'controller' => GiftController::class,
                        'action'    => 'index'
                    ]
                ]
            ],

            'operation-repurchase' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/' . Config::ADMIN_PATH . '/operation-repurchase[/:action[/:id]]',
                    'defaults' => [
                        'controller' => RepurchaseController::class,
                        'action'    => 'index'
                    ]
                ]
            ],

            'operation-buy-together' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/' . Config::ADMIN_PATH . '/operation-buy-together[/:action[/:id]]',
                    'defaults' => [
                        'controller' => BuyTogetherController::class,
                        'action'    => 'index'
                    ]
                ]
            ],

            'operation-bargain' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/' . Config::ADMIN_PATH . '/operation-bargain[/:action[/:id]]',
                    'defaults' => [
                        'controller' => BargainController::class,
                        'action'    => 'index'
                    ]
                ]
            ],

            'operation-group-buy' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/' . Config::ADMIN_PATH . '/operation-group-buy[/:action[/:id]]',
                    'defaults' => [
                        'controller' => GroupBuyController::class,
                        'action'    => 'index'
                    ]
                ]
            ],

            'operation-advance-sale' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/' . Config::ADMIN_PATH . '/operation-advance-sale[/:action[/:id]]',
                    'defaults' => [
                        'controller' => AdvanceSaleController::class,
                        'action'    => 'index'
                    ]
                ]
            ],

            'operation-theme' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/' . Config::ADMIN_PATH . '/operation-theme[/:action[/:id]]',
                    'defaults' => [
                        'controller' => ThemeController::class,
                        'action'    => 'index'
                    ]
                ]
            ],

        ]

    ],

    'controllers' => [
        'factories' => [
            AdController::class             => AdControllerFactory::class,          //广告
            IndexController::class          => IndexControllerFactory::class,
            DiscountController::class       => DiscountControllerFactory::class,    //优惠促销
            CouponController::class         => CouponControllerFactory::class,      //优惠券
            CouponCodeController::class     => CouponCodeControllerFactory::class,  //优惠码
            RechargeCodeController::class   => RechargeCodeControllerFactory::class,//充值码
            GiftController::class           => GiftControllerFactory::class,        //赠品
            RepurchaseController::class     => RepurchaseControllerFactory::class,  //换购
            BuyTogetherController::class    => BuyTogetherControllerFactory::class, //拼团
            BargainController::class        => BargainControllerFactory::class,     //砍价
            GroupBuyController::class       => GroupBuyControllerFactory::class,    //团购
            AdvanceSaleController::class    => AdvanceSaleControllerFactory::class, //预售
            ThemeController::class          => ThemeControllerFactory::class,       //专题
        ]
    ],

    'service_manager' => [
        'factories' => [
            AdManager::class            => AdManagerFactory::class,
            AdSlideManager::class       => AdSlideManagerFactory::class,
            DiscountRuleManager::class  => DiscountRuleManagerFactory::class,
            CouponManager::class        => CouponManagerFactory::class,
            UserCouponManager::class    => UserCouponManagerFactory::class,
            RechargeCodeRuleManager::class => RechargeCodeRuleManagerFactory::class,
            RechargeCodeManager::class  => RechargeCodeManagerFactory::class,

            OperationListener::class    => OperationListenerFactory::class
        ]
    ],

    'listeners' => [
        OperationListener::class
    ],

    'permission_filter' => include __DIR__ . '/permission.php',

    'controller_plugins' => [
        'factories' => [

        ],
        'aliases'   => [

        ]
    ],

    'view_helpers' => [
        'factories' => [
            OperationHelper::class  => OperationHelperFactory::class
        ],
        'aliases' => [
            'operationHelper' => OperationHelper::class
        ],
    ],

    'translator' => [
        'translation_file_patterns' => [
            [
                'type' => 'gettext',
                'base_dir' => __DIR__ . '/../data/language',
                'pattern' => '%s.mo'
            ]
        ]
    ],

    'view_manager' => [
        'template_path_stack' => [
            __DIR__ . '/../view',
        ],
        'strategies' => [
            'ViewJsonStrategy',
        ]
    ],

    'doctrine' => [
        'driver' => [
            __NAMESPACE__ . '_driver' => [
                'class' => AnnotationDriver::class,
                'cache' => 'array',
                'paths' => [__DIR__ . '/../src/Entity']
            ],
            'orm_default' => [
                'drivers' => [
                    __NAMESPACE__ . '\Entity' => __NAMESPACE__ . '_driver'
                ]
            ]
        ]
    ]
];