<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Operation;

use Operation\Controller\AdController;
use Operation\Controller\CouponController;
use Operation\Controller\DiscountController;
use Operation\Controller\RechargeCodeController;

return [
    'Operation' => [
        'name' => '运营',
        'controllers' => [
            DiscountController::class => [
                'name' => '优惠促销',
                'action' => ['index', 'add', 'edit', 'delete'],
                'actionNames' => [
                    'index' => '促销规则列表',
                    'add'   => '添加促销规则',
                    'edit'  => '编辑促销规则',
                    'delete'=> '删除促销规则'
                ]
            ],

            CouponController::class => [
                'name' => '优惠券',
                'action' => ['index', 'add', 'edit', 'delete'],
                'actionNames' => [
                    'index' => '优惠券列表',
                    'add'   => '添加优惠券',
                    'edit'  => '编辑优惠券',
                    'delete'=> '删除优惠券'
                ]
            ],

            RechargeCodeController::class => [
                'name' => '充值码',
                'action' => [
                    'index', 'add', 'edit', 'delete', 'createRechargeCode',
                    'rechargeCodeList', 'exportRechargeCode'
                ],
                'actionNames' => [
                    'index' => '充值码规则列表',
                    'add'   => '添加充值码规则',
                    'edit'  => '编辑充值码规则',
                    'delete'=> '删除充值码规则',
                    'createRechargeCode'=> '再次生成充值码',

                    'rechargeCodeList'  => '充值码列表',
                    'exportRechargeCode'=> '导出充值码'
                ]
            ],

            AdController::class => [
                'name' => '广告',
                'action' => [
                    'index', 'adEdit',
                    'mobileAdList', 'mobileAdEdit',
                    'adDelete',
                ],
                'actionNames' => [
                    'index'         => '电脑广告列表',
                    'adEdit'        => '添加编辑电脑广告',

                    'mobileAdList'  => '手机广告列表',
                    'mobileAdEdit'  => '添加编辑手机广告',

                    'adDelete'      => '广告清除'
                ]
            ]
        ]
    ]
];