<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Operation\Controller\Factory;

use Admin\Data\Config;
use Interop\Container\ContainerInterface;
use Laminas\Mvc\I18n\Translator;
use Laminas\ServiceManager\Factory\FactoryInterface;
use Operation\Controller\AdController;
use Operation\Service\AdManager;
use Operation\Service\AdSlideManager;

class AdControllerFactory implements FactoryInterface
{
    public function __invoke(ContainerInterface $container, $requestedName, array $options = null)
    {
        $translator         = $container->get(Translator::class);
        $entityManager      = $container->get(Config::SHOP_DATABASE_MANAGER_WRITE);
        $adManager          = $container->get(AdManager::class);
        $adSlideManager     = $container->get(AdSlideManager::class);

        return new AdController($translator, $entityManager, $adManager, $adSlideManager);
    }
}