<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Operation\Controller\Factory;

use Admin\Data\Config;
use Interop\Container\ContainerInterface;
use Laminas\Mvc\I18n\Translator;
use Laminas\ServiceManager\Factory\FactoryInterface;
use Operation\Controller\CouponController;
use Operation\Service\CouponManager;
use Operation\Service\UserCouponManager;

class CouponControllerFactory implements FactoryInterface
{
    public function __invoke(ContainerInterface $container, $requestedName, array $options = null)
    {
        $translator         = $container->get(Translator::class);
        $entityManager      = $container->get(Config::SHOP_DATABASE_MANAGER_WRITE);
        $couponManager      = $container->get(CouponManager::class);
        $userCouponManager  = $container->get(UserCouponManager::class);

        return new CouponController(
            $translator,
            $entityManager,
            $couponManager,
            $userCouponManager
        );
    }
}