<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Operation\Entity;

use Admin\Entity\BaseEntity;
use Doctrine\ORM\Mapping as ORM;

/**
 * 广告表
 * Class Ad
 * @package Operation\Entity
 * @ORM\Entity(repositoryClass="Operation\Repository\AdRepository")
 * @ORM\Table(name="dbshop_ad")
 */
class Ad extends BaseEntity
{
    /**
     * 自增id
     * @ORM\Id()
     * @ORM\Column(name="ad_id", type="integer", length=11)
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $adId;

    /**
     * 广告类型，如 index 首页
     * @ORM\Column(name="ad_class", type="string", length=30)
     */
    private $adClass;

    /**
     * 广告位置标记
     * @ORM\Column(name="ad_place_code", type="string", length=50)
     */
    private $adPlaceCode;

    /**
     * 商品分类id字符串，用逗号“,”分隔
     * @ORM\Column(name="goods_class_id_str", type="string", length=500)
     */
    private $goodsClassIdStr;

    /**
     * 广告类型，slide 幻灯片，image 图片
     * @ORM\Column(name="ad_type", type="string", length=20)
     */
    private $adType;

    /**
     * 广告宽度
     * @ORM\Column(name="ad_width", type="integer", length=11)
     */
    private $adWidth;

    /**
     * 广告高度
     * @ORM\Column(name="ad_height", type="integer", length=11)
     */
    private $adHeight;

    /**
     * 广告开始时间
     * @ORM\Column(name="ad_start_time", type="integer", length=10)
     */
    private $adStartTime;

    /**
     * 广告结束时间
     * @ORM\Column(name="ad_end_time", type="integer", length=10)
     */
    private $adEndTime;

    /**
     * 广告url
     * @ORM\Column(name="ad_url", type="string", length=500)
     */
    private $adUrl;

    /**
     * 广告内容
     * @ORM\Column(name="ad_body", type="string", length=500)
     */
    private $adBody;

    /**
     * 广告状态，0 禁用，1 启用
     * @ORM\Column(name="ad_state", type="integer", length=1)
     */
    private $adState;

    /**
     * 模板标记
     * @ORM\Column(name="template_code", type="string", length=50)
     */
    private $templateCode;

    /**
     * @return mixed
     */
    public function getAdId()
    {
        return $this->adId;
    }

    /**
     * @param mixed $adId
     */
    public function setAdId($adId): void
    {
        $this->adId = $adId;
    }

    /**
     * @return mixed
     */
    public function getAdClass()
    {
        return $this->adClass;
    }

    /**
     * @param mixed $adClass
     */
    public function setAdClass($adClass): void
    {
        $this->adClass = $adClass;
    }

    /**
     * @return mixed
     */
    public function getAdPlaceCode()
    {
        return $this->adPlaceCode;
    }

    /**
     * @param mixed $adPlaceCode
     */
    public function setAdPlaceCode($adPlaceCode): void
    {
        $this->adPlaceCode = $adPlaceCode;
    }

    /**
     * @return mixed
     */
    public function getGoodsClassIdStr()
    {
        return $this->goodsClassIdStr;
    }

    /**
     * @param mixed $goodsClassIdStr
     */
    public function setGoodsClassIdStr($goodsClassIdStr): void
    {
        $this->goodsClassIdStr = $goodsClassIdStr;
    }

    /**
     * @return mixed
     */
    public function getAdType()
    {
        return $this->adType;
    }

    /**
     * @param mixed $adType
     */
    public function setAdType($adType): void
    {
        $this->adType = $adType;
    }

    /**
     * @return mixed
     */
    public function getAdWidth()
    {
        return $this->adWidth;
    }

    /**
     * @param mixed $adWidth
     */
    public function setAdWidth($adWidth): void
    {
        $this->adWidth = $adWidth;
    }

    /**
     * @return mixed
     */
    public function getAdHeight()
    {
        return $this->adHeight;
    }

    /**
     * @param mixed $adHeight
     */
    public function setAdHeight($adHeight): void
    {
        $this->adHeight = $adHeight;
    }

    /**
     * @return mixed
     */
    public function getAdStartTime()
    {
        return $this->adStartTime;
    }

    /**
     * @param mixed $adStartTime
     */
    public function setAdStartTime($adStartTime): void
    {
        $this->adStartTime = $adStartTime;
    }

    /**
     * @return mixed
     */
    public function getAdEndTime()
    {
        return $this->adEndTime;
    }

    /**
     * @param mixed $adEndTime
     */
    public function setAdEndTime($adEndTime): void
    {
        $this->adEndTime = $adEndTime;
    }

    /**
     * @return mixed
     */
    public function getAdUrl()
    {
        return $this->adUrl;
    }

    /**
     * @param mixed $adUrl
     */
    public function setAdUrl($adUrl): void
    {
        $this->adUrl = $adUrl;
    }

    /**
     * @return mixed
     */
    public function getAdBody()
    {
        return $this->adBody;
    }

    /**
     * @param mixed $adBody
     */
    public function setAdBody($adBody): void
    {
        $this->adBody = $adBody;
    }

    /**
     * @return mixed
     */
    public function getAdState()
    {
        return $this->adState;
    }

    /**
     * @param mixed $adState
     */
    public function setAdState($adState): void
    {
        $this->adState = $adState;
    }

    /**
     * @return mixed
     */
    public function getTemplateCode()
    {
        return $this->templateCode;
    }

    /**
     * @param mixed $templateCode
     */
    public function setTemplateCode($templateCode): void
    {
        $this->templateCode = $templateCode;
    }
}