<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Operation\Entity;

use Admin\Entity\BaseEntity;
use Doctrine\ORM\Mapping as ORM;

/**
 * 幻灯片广告
 * Class AdSlide
 * @package Operation\Entity
 * @ORM\Entity(repositoryClass="Operation\Repository\AdSlideRepository")
 * @ORM\Table(name="dbshop_ad_slide")
 */
class AdSlide extends BaseEntity
{
    /**
     * 自增id
     * @ORM\Id()
     * @ORM\Column(name="ad_slide_id", type="integer", length=11)
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $adSlideId;

    /**
     * 对应的广告id
     * @ORM\Column(name="ad_id", type="integer", length=11)
     */
    private $adId;

    /**
     * 图片
     * @ORM\Column(name="ad_slide_image", type="string", length=300)
     */
    private $adSlideImage;

    /**
     * 幻灯片排序，默认 255
     * @ORM\Column(name="ad_slide_sort", type="integer", length=11)
     */
    private $adSlideSort;

    /**
     * url
     * @ORM\Column(name="ad_slide_url", type="string", length=500)
     */
    private $adSlideUrl;

    /**
     * @return mixed
     */
    public function getAdSlideId()
    {
        return $this->adSlideId;
    }

    /**
     * @param mixed $adSlideId
     */
    public function setAdSlideId($adSlideId): void
    {
        $this->adSlideId = $adSlideId;
    }

    /**
     * @return mixed
     */
    public function getAdId()
    {
        return $this->adId;
    }

    /**
     * @param mixed $adId
     */
    public function setAdId($adId): void
    {
        $this->adId = $adId;
    }

    /**
     * @return mixed
     */
    public function getAdSlideImage()
    {
        return $this->adSlideImage;
    }

    /**
     * @param mixed $adSlideImage
     */
    public function setAdSlideImage($adSlideImage): void
    {
        $this->adSlideImage = $adSlideImage;
    }

    /**
     * @return mixed
     */
    public function getAdSlideSort()
    {
        return $this->adSlideSort;
    }

    /**
     * @param mixed $adSlideSort
     */
    public function setAdSlideSort($adSlideSort): void
    {
        $this->adSlideSort = $adSlideSort;
    }

    /**
     * @return mixed
     */
    public function getAdSlideUrl()
    {
        return $this->adSlideUrl;
    }

    /**
     * @param mixed $adSlideUrl
     */
    public function setAdSlideUrl($adSlideUrl): void
    {
        $this->adSlideUrl = $adSlideUrl;
    }
}