<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Operation\Entity;

use Admin\Entity\BaseEntity;
use Doctrine\ORM\Mapping as ORM;

/**
 * 优惠券
 * Class Coupon
 * @package Operation\Entity
 * @ORM\Entity(repositoryClass="Operation\Repository\CouponRepository")
 * @ORM\Table(name="dbshop_coupon")
 */
class Coupon extends BaseEntity
{
    /**
     * 自增id
     * @ORM\Id()
     * @ORM\Column(name="coupon_id", type="integer", length=11)
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $couponId;

    /**
     * 优惠券标题
     * @ORM\Column(name="coupon_title", type="string", length=150)
     */
    private $couponTitle;

    /**
     * 优惠券描述
     * @ORM\Column(name="coupon_info", type="string", length=300)
     */
    private $couponInfo;

    /**
     * 优惠券使用开始时间
     * @ORM\Column(name="coupon_start_time", type="integer", length=10)
     */
    private $couponStartTime = 0;

    /**
     * 优惠券使用结束时间
     * @ORM\Column(name="coupon_end_time", type="integer", length=10)
     */
    private $couponEndTime = 0;

    /**
     * 优惠券状态
     * @ORM\Column(name="coupon_state", type="integer", length=1)
     */
    private $couponState;

    /**
     * 购物金额
     * @ORM\Column(name="shopping_amount", type="integer", length=11)
     */
    private $shoppingAmount;

    /**
     * 优惠券优惠金额
     * @ORM\Column(name="shopping_discount", type="integer", length=11)
     */
    private $shoppingDiscount;

    /**
     * 获取优惠券的开始时间
     * @ORM\Column(name="get_coupon_start_time", type="integer", length=10)
     */
    private $getCouponStartTime = 0;

    /**
     * 获取优惠券的结束时间
     * @ORM\Column(name="get_coupon_end_time", type="integer", length=10)
     */
    private $getCouponEndTime = 0;

    /**
     * 获取优惠券方式
     * @ORM\Column(name="get_coupon_type", type="string", length=50)
     */
    private $getCouponType;

    /**
     * 购物金额（当获取方式为购物获取时）
     * @ORM\Column(name="get_shopping_amount", type="integer", length=11)
     */
    private $getShoppingAmount;

    /**
     * 购物满获取优惠券次数（每人），
     * @ORM\Column(name="user_get_frequency", type="integer", length=11)
     */
    private $userGetFrequency;

    /**
     * 会员类型
     * @ORM\Column(name="get_user_type", type="string", length=50)
     */
    private $getUserType;

    /**
     * 会员分组内容
     * @ORM\Column(name="get_user_group", type="text")
     */
    private $getUserGroup;

    /**
     * 商品类型
     * @ORM\Column(name="get_goods_type", type="string", length=50)
     */
    private $getGoodsType;

    /**
     * 商品类型内容，如商品分类、品牌
     * @ORM\Column(name="get_goods_body", type="text")
     */
    private $getGoodsBody;

    /**
     * @return mixed
     */
    public function getCouponId()
    {
        return $this->couponId;
    }

    /**
     * @param mixed $couponId
     */
    public function setCouponId($couponId): void
    {
        $this->couponId = $couponId;
    }

    /**
     * @return mixed
     */
    public function getCouponTitle()
    {
        return $this->couponTitle;
    }

    /**
     * @param mixed $couponTitle
     */
    public function setCouponTitle($couponTitle): void
    {
        $this->couponTitle = $couponTitle;
    }

    /**
     * @return mixed
     */
    public function getCouponInfo()
    {
        return $this->couponInfo;
    }

    /**
     * @param mixed $couponInfo
     */
    public function setCouponInfo($couponInfo): void
    {
        $this->couponInfo = $couponInfo;
    }

    /**
     * @return mixed
     */
    public function getCouponStartTime()
    {
        return $this->couponStartTime;
    }

    /**
     * @param mixed $couponStartTime
     */
    public function setCouponStartTime($couponStartTime): void
    {
        $this->couponStartTime = $couponStartTime;
    }

    /**
     * @return mixed
     */
    public function getCouponEndTime()
    {
        return $this->couponEndTime;
    }

    /**
     * @param mixed $couponEndTime
     */
    public function setCouponEndTime($couponEndTime): void
    {
        $this->couponEndTime = $couponEndTime;
    }

    /**
     * @return mixed
     */
    public function getCouponState()
    {
        return $this->couponState;
    }

    /**
     * @param mixed $couponState
     */
    public function setCouponState($couponState): void
    {
        $this->couponState = $couponState;
    }

    /**
     * @return mixed
     */
    public function getShoppingAmount()
    {
        return $this->shoppingAmount;
    }

    /**
     * @param mixed $shoppingAmount
     */
    public function setShoppingAmount($shoppingAmount): void
    {
        $this->shoppingAmount = $shoppingAmount;
    }

    /**
     * @return mixed
     */
    public function getUserGetFrequency()
    {
        return $this->userGetFrequency;
    }

    /**
     * @param mixed $userGetFrequency
     */
    public function setUserGetFrequency($userGetFrequency): void
    {
        $this->userGetFrequency = $userGetFrequency;
    }

    /**
     * @return mixed
     */
    public function getShoppingDiscount()
    {
        return $this->shoppingDiscount;
    }

    /**
     * @param mixed $shoppingDiscount
     */
    public function setShoppingDiscount($shoppingDiscount): void
    {
        $this->shoppingDiscount = $shoppingDiscount;
    }

    /**
     * @return mixed
     */
    public function getGetCouponStartTime()
    {
        return $this->getCouponStartTime;
    }

    /**
     * @param mixed $getCouponStartTime
     */
    public function setGetCouponStartTime($getCouponStartTime): void
    {
        $this->getCouponStartTime = $getCouponStartTime;
    }

    /**
     * @return mixed
     */
    public function getGetCouponEndTime()
    {
        return $this->getCouponEndTime;
    }

    /**
     * @param mixed $getCouponEndTime
     */
    public function setGetCouponEndTime($getCouponEndTime): void
    {
        $this->getCouponEndTime = $getCouponEndTime;
    }

    /**
     * @return mixed
     */
    public function getGetCouponType()
    {
        return $this->getCouponType;
    }

    /**
     * @param mixed $getCouponType
     */
    public function setGetCouponType($getCouponType): void
    {
        $this->getCouponType = $getCouponType;
    }

    /**
     * @return mixed
     */
    public function getGetShoppingAmount()
    {
        return $this->getShoppingAmount;
    }

    /**
     * @param mixed $getShoppingAmount
     */
    public function setGetShoppingAmount($getShoppingAmount): void
    {
        $this->getShoppingAmount = $getShoppingAmount;
    }

    /**
     * @return mixed
     */
    public function getGetUserType()
    {
        return $this->getUserType;
    }

    /**
     * @param mixed $getUserType
     */
    public function setGetUserType($getUserType): void
    {
        $this->getUserType = $getUserType;
    }

    /**
     * @return mixed
     */
    public function getGetUserGroup()
    {
        return $this->getUserGroup;
    }

    /**
     * @param mixed $getUserGroup
     */
    public function setGetUserGroup($getUserGroup): void
    {
        $this->getUserGroup = $getUserGroup;
    }

    /**
     * @return mixed
     */
    public function getGetGoodsType()
    {
        return $this->getGoodsType;
    }

    /**
     * @param mixed $getGoodsType
     */
    public function setGetGoodsType($getGoodsType): void
    {
        $this->getGoodsType = $getGoodsType;
    }

    /**
     * @return mixed
     */
    public function getGetGoodsBody()
    {
        return $this->getGoodsBody;
    }

    /**
     * @param mixed $getGoodsBody
     */
    public function setGetGoodsBody($getGoodsBody): void
    {
        $this->getGoodsBody = $getGoodsBody;
    }
}