<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Operation\Entity;

use Admin\Entity\BaseEntity;
use Doctrine\ORM\Mapping as ORM;

/**
 * 优惠促销规则
 * Class DiscountRule
 * @package Operation\Entity
 * @ORM\Entity(repositoryClass="Operation\Repository\DiscountRuleRepository")
 * @ORM\Table(name="dbshop_discount_rule")
 */
class DiscountRule extends BaseEntity
{
    /**
     * 自增id
     * @ORM\Id()
     * @ORM\Column(name="discount_rule_id", type="integer", length=11)
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $discountRuleId;

    /**
     * 优惠名称
     * @ORM\Column(name="discount_rule_title", type="string", length=150)
     */
    private $discountRuleTitle;

    /**
     * 优惠描述
     * @ORM\Column(name="discount_rule_info", type="string", length=500)
     */
    private $discountRuleInfo;

    /**
     * 开始时间
     * @ORM\Column(name="discount_start_time", type="integer", length=10)
     */
    private $discountStartTime = 0;

    /**
     * 结束时间
     * @ORM\Column(name="discount_end_time", type="integer", length=10)
     */
    private $discountEndTime = 0;

    /**
     * 购买次数（每人）
     * @ORM\Column(name="user_buy_frequency", type="integer", length=11)
     */
    private $userBuyFrequency;

    /**
     * 状态，0 禁用，1 启用
     * @ORM\Column(name="discount_state", type="integer", length=1)
     */
    private $discountState;

    /**
     * 购买类型，1 满X元，2 每X元
     * @ORM\Column(name="goods_buy_type", type="integer", length=1)
     */
    private $goodsBuyType;

    /**
     * 购物金额
     * @ORM\Column(name="goods_buy_amount", type="integer", length=11)
     */
    private $goodsBuyAmount = 0;

    /**
     * 优惠金额（百分比），这里的优惠是减少的金额
     * @ORM\Column(name="buy_discount", type="integer", length=11)
     */
    private $buyDiscount = 0;

    /**
     * 优惠模式，1 金额元，2 百分比
     * @ORM\Column(name="discount_mode", type="integer", length=1)
     */
    private $discountMode;

    /**
     * 客户组类型，allUser 所有客户，userGroup 客户组
     * @ORM\Column(name="discount_user_type", type="string", length=30)
     */
    private $discountUserType;

    /**
     * 个性化客户组内容
     * @ORM\Column(name="discount_user_group", type="text")
     */
    private $discountUserGroup;

    /**
     * 商品类型，allGoods 所有商品，goodsClass 商品分类，goodsBrand 商品品牌
     * @ORM\Column(name="discount_goods_type", type="string", length=30)
     */
    private $discountGoodsType;

    /**
     * 商品类型的内容，如 商品分类、商品品牌、个别商品
     * @ORM\Column(name="discount_goods_body", type="text")
     */
    private $discountGoodsBody;

    /**
     * @return mixed
     */
    public function getDiscountRuleId()
    {
        return $this->discountRuleId;
    }

    /**
     * @param mixed $discountRuleId
     */
    public function setDiscountRuleId($discountRuleId): void
    {
        $this->discountRuleId = $discountRuleId;
    }

    /**
     * @return mixed
     */
    public function getDiscountRuleTitle()
    {
        return $this->discountRuleTitle;
    }

    /**
     * @param mixed $discountRuleTitle
     */
    public function setDiscountRuleTitle($discountRuleTitle): void
    {
        $this->discountRuleTitle = $discountRuleTitle;
    }

    /**
     * @return mixed
     */
    public function getDiscountRuleInfo()
    {
        return $this->discountRuleInfo;
    }

    /**
     * @param mixed $discountRuleInfo
     */
    public function setDiscountRuleInfo($discountRuleInfo): void
    {
        $this->discountRuleInfo = $discountRuleInfo;
    }

    /**
     * @return mixed
     */
    public function getDiscountStartTime()
    {
        return $this->discountStartTime;
    }

    /**
     * @param mixed $discountStartTime
     */
    public function setDiscountStartTime($discountStartTime): void
    {
        $this->discountStartTime = $discountStartTime;
    }

    /**
     * @return mixed
     */
    public function getUserBuyFrequency()
    {
        return $this->userBuyFrequency;
    }

    /**
     * @param mixed $userBuyFrequency
     */
    public function setUserBuyFrequency($userBuyFrequency): void
    {
        $this->userBuyFrequency = $userBuyFrequency;
    }

    /**
     * @return mixed
     */
    public function getDiscountEndTime()
    {
        return $this->discountEndTime;
    }

    /**
     * @param mixed $discountEndTime
     */
    public function setDiscountEndTime($discountEndTime): void
    {
        $this->discountEndTime = $discountEndTime;
    }

    /**
     * @return mixed
     */
    public function getDiscountState()
    {
        return $this->discountState;
    }

    /**
     * @param mixed $discountState
     */
    public function setDiscountState($discountState): void
    {
        $this->discountState = $discountState;
    }

    /**
     * @return mixed
     */
    public function getGoodsBuyType()
    {
        return $this->goodsBuyType;
    }

    /**
     * @param mixed $goodsBuyType
     */
    public function setGoodsBuyType($goodsBuyType): void
    {
        $this->goodsBuyType = $goodsBuyType;
    }

    /**
     * @return mixed
     */
    public function getGoodsBuyAmount()
    {
        return $this->goodsBuyAmount;
    }

    /**
     * @param mixed $goodsBuyAmount
     */
    public function setGoodsBuyAmount($goodsBuyAmount): void
    {
        $this->goodsBuyAmount = $goodsBuyAmount;
    }

    /**
     * @return mixed
     */
    public function getBuyDiscount()
    {
        return $this->buyDiscount;
    }

    /**
     * @param mixed $buyDiscount
     */
    public function setBuyDiscount($buyDiscount): void
    {
        $this->buyDiscount = $buyDiscount;
    }

    /**
     * @return mixed
     */
    public function getDiscountMode()
    {
        return $this->discountMode;
    }

    /**
     * @param mixed $discountMode
     */
    public function setDiscountMode($discountMode): void
    {
        $this->discountMode = $discountMode;
    }

    /**
     * @return mixed
     */
    public function getDiscountUserType()
    {
        return $this->discountUserType;
    }

    /**
     * @param mixed $discountUserType
     */
    public function setDiscountUserType($discountUserType): void
    {
        $this->discountUserType = $discountUserType;
    }

    /**
     * @return mixed
     */
    public function getDiscountUserGroup()
    {
        return $this->discountUserGroup;
    }

    /**
     * @param mixed $discountUserGroup
     */
    public function setDiscountUserGroup($discountUserGroup): void
    {
        $this->discountUserGroup = $discountUserGroup;
    }

    /**
     * @return mixed
     */
    public function getDiscountGoodsType()
    {
        return $this->discountGoodsType;
    }

    /**
     * @param mixed $discountGoodsType
     */
    public function setDiscountGoodsType($discountGoodsType): void
    {
        $this->discountGoodsType = $discountGoodsType;
    }

    /**
     * @return mixed
     */
    public function getDiscountGoodsBody()
    {
        return $this->discountGoodsBody;
    }

    /**
     * @param mixed $discountGoodsBody
     */
    public function setDiscountGoodsBody($discountGoodsBody): void
    {
        $this->discountGoodsBody = $discountGoodsBody;
    }
}