<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Operation\Entity;

use Admin\Entity\BaseEntity;
use Doctrine\ORM\Mapping as ORM;

/**
 * 充值码生成
 * Class RechargeCode
 * @package Operation\Entity
 * @ORM\Entity(repositoryClass="Operation\Repository\RechargeCodeRepository")
 * @ORM\Table(name="dbshop_recharge_code")
 */
class RechargeCode extends BaseEntity
{
    /**
     * 自增id
     * @ORM\Id()
     * @ORM\Column(name="code_id", type="integer", length=11)
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $codeId;

    /**
     * 充值码规则id
     * @ORM\Column(name="code_rule_id", type="integer", length=11)
     */
    private $codeRuleId;

    /**
     * 充值码金额
     * @ORM\Column(name="code_money", type="decimal", scale=2)
     */
    private $codeMoney;

    /**
     * 充值码
     * @ORM\Column(name="code_str", type="string", length=100)
     */
    private $codeStr;

    /**
     * 会员id
     * @ORM\Column(name="user_id", type="integer", length=11)
     */
    private $userId = 0;

    /**
     * 会员名称
     * @ORM\Column(name="user_name", type="string", length=100)
     */
    private $userName;

    /**
     * 充值码充值时间
     * @ORM\Column(name="code_recharge_time", type="integer", length=10)
     */
    private $codeRechargeTime = 0;

    /**
     * 充值码生成时间
     * @ORM\Column(name="code_create_time", type="integer", length=10)
     */
    private $codeCreateTime;

    /**
     * @return mixed
     */
    public function getCodeId()
    {
        return $this->codeId;
    }

    /**
     * @param mixed $codeId
     */
    public function setCodeId($codeId): void
    {
        $this->codeId = $codeId;
    }

    /**
     * @return mixed
     */
    public function getCodeRuleId()
    {
        return $this->codeRuleId;
    }

    /**
     * @param mixed $codeRuleId
     */
    public function setCodeRuleId($codeRuleId): void
    {
        $this->codeRuleId = $codeRuleId;
    }

    /**
     * @return mixed
     */
    public function getCodeMoney()
    {
        return $this->codeMoney;
    }

    /**
     * @param mixed $codeMoney
     */
    public function setCodeMoney($codeMoney): void
    {
        $this->codeMoney = $codeMoney;
    }

    /**
     * @return mixed
     */
    public function getCodeStr()
    {
        return $this->codeStr;
    }

    /**
     * @param mixed $codeStr
     */
    public function setCodeStr($codeStr): void
    {
        $this->codeStr = $codeStr;
    }

    /**
     * @return mixed
     */
    public function getUserId()
    {
        return $this->userId;
    }

    /**
     * @param mixed $userId
     */
    public function setUserId($userId): void
    {
        $this->userId = $userId;
    }

    /**
     * @return mixed
     */
    public function getUserName()
    {
        return $this->userName;
    }

    /**
     * @param mixed $userName
     */
    public function setUserName($userName): void
    {
        $this->userName = $userName;
    }

    /**
     * @return mixed
     */
    public function getCodeRechargeTime()
    {
        return $this->codeRechargeTime;
    }

    /**
     * @param mixed $codeRechargeTime
     */
    public function setCodeRechargeTime($codeRechargeTime): void
    {
        $this->codeRechargeTime = $codeRechargeTime;
    }

    /**
     * @return mixed
     */
    public function getCodeCreateTime()
    {
        return $this->codeCreateTime;
    }

    /**
     * @param mixed $codeCreateTime
     */
    public function setCodeCreateTime($codeCreateTime): void
    {
        $this->codeCreateTime = $codeCreateTime;
    }
}