<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Operation\Entity;

use Admin\Entity\BaseEntity;
use Doctrine\ORM\Mapping as ORM;

/**
 * 充值码生成规则
 * Class RechargeCodeRule
 * @package Operation\Entity
 * @ORM\Entity(repositoryClass="Operation\Repository\RechargeCodeRuleRepository")
 * @ORM\Table(name="dbshop_recharge_code_rule")
 */
class RechargeCodeRule extends BaseEntity
{
    /**
     * 自增id
     * @ORM\Id()
     * @ORM\Column(name="code_rule_id", type="integer", length=11)
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $codeRuleId;

    /**
     * 充值规则标题
     * @ORM\Column(name="code_rule_title", type="string", length=200)
     */
    private $codeRuleTitle;

    /**
     * 充值码单个金额
     * @ORM\Column(name="code_one_money", type="decimal", scale=2)
     */
    private $codeOneMoney;

    /**
     * 充值码数量
     * @ORM\Column(name="code_num", type="integer", length=11)
     */
    private $codeNum;

    /**
     * 充值生效开始时间
     * @ORM\Column(name="code_start_time", type="integer", length=10)
     */
    private $codeStartTime;

    /**
     * 充值结束时间
     * @ORM\Column(name="code_end_time", type="integer", length=10)
     */
    private $codeEndTime;

    /**
     * 状态，1 启用，0 禁用
     * @ORM\Column(name="code_rule_state", type="integer", length=1)
     */
    private $codeRuleState;

    /**
     * 规则添加时间
     * @ORM\Column(name="code_rule_add_time", type="integer", length=10)
     */
    private $codeRuleAddTime;

    /**
     * @return mixed
     */
    public function getCodeRuleId()
    {
        return $this->codeRuleId;
    }

    /**
     * @param mixed $codeRuleId
     */
    public function setCodeRuleId($codeRuleId): void
    {
        $this->codeRuleId = $codeRuleId;
    }

    /**
     * @return mixed
     */
    public function getCodeRuleTitle()
    {
        return $this->codeRuleTitle;
    }

    /**
     * @param mixed $codeRuleTitle
     */
    public function setCodeRuleTitle($codeRuleTitle): void
    {
        $this->codeRuleTitle = $codeRuleTitle;
    }

    /**
     * @return mixed
     */
    public function getCodeOneMoney()
    {
        return $this->codeOneMoney;
    }

    /**
     * @param mixed $codeOneMoney
     */
    public function setCodeOneMoney($codeOneMoney): void
    {
        $this->codeOneMoney = $codeOneMoney;
    }

    /**
     * @return mixed
     */
    public function getCodeNum()
    {
        return $this->codeNum;
    }

    /**
     * @param mixed $codeNum
     */
    public function setCodeNum($codeNum): void
    {
        $this->codeNum = $codeNum;
    }

    /**
     * @return mixed
     */
    public function getCodeStartTime()
    {
        return $this->codeStartTime;
    }

    /**
     * @param mixed $codeStartTime
     */
    public function setCodeStartTime($codeStartTime): void
    {
        $this->codeStartTime = $codeStartTime;
    }

    /**
     * @return mixed
     */
    public function getCodeEndTime()
    {
        return $this->codeEndTime;
    }

    /**
     * @param mixed $codeEndTime
     */
    public function setCodeEndTime($codeEndTime): void
    {
        $this->codeEndTime = $codeEndTime;
    }

    /**
     * @return mixed
     */
    public function getCodeRuleState()
    {
        return $this->codeRuleState;
    }

    /**
     * @param mixed $codeRuleState
     */
    public function setCodeRuleState($codeRuleState): void
    {
        $this->codeRuleState = $codeRuleState;
    }

    /**
     * @return mixed
     */
    public function getCodeRuleAddTime()
    {
        return $this->codeRuleAddTime;
    }

    /**
     * @param mixed $codeRuleAddTime
     */
    public function setCodeRuleAddTime($codeRuleAddTime): void
    {
        $this->codeRuleAddTime = $codeRuleAddTime;
    }
}