<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Operation\Entity;

use Admin\Entity\BaseEntity;
use Doctrine\ORM\Mapping as ORM;

/**
 * 客户获取优惠券
 * Class UserCoupon
 * @package Operation\Entity
 * @ORM\Entity(repositoryClass="Operation\Repository\UserCouponRepository")
 * @ORM\Table(name="dbshop_user_coupon")
 */
class UserCoupon extends BaseEntity
{
    /**
     * 自增id
     * @ORM\Id()
     * @ORM\Column(name="user_coupon_id", type="integer", length=11)
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $userCouponId;

    /**
     * 优惠券使用状态 0 不可用，1 可用，2 已用，3 过期
     * @ORM\Column(name="coupon_use_state", type="integer", length=1)
     */
    private $couponUseState = 0;

    /**
     * 会员id
     * @ORM\Column(name="user_id", type="integer", length=11)
     */
    private $userId;

    /**
     * 会员名称
     * @ORM\Column(name="user_name", type="string", length=100)
     */
    private $userName;

    /**
     * 优惠券使用的订单id
     * @ORM\Column(name="used_order_id", type="integer", length=11)
     */
    private $usedOrderId = 0;

    /**
     * 优惠券使用的订单编号
     * @ORM\Column(name="used_order_sn", type="string", length=50)
     */
    private $usedOrderSn;

    /**
     * 优惠券使用的时间
     * @ORM\Column(name="used_time", type="integer", length=10)
     */
    private $usedTime = 0;

    /**
     * 通过购买获取优惠券的订单id
     * @ORM\Column(name="get_order_id", type="integer", length=11)
     */
    private $getOrderId = 0;

    /**
     * 通过购买获取优惠券的订单编号
     * @ORM\Column(name="get_order_sn", type="string", length=50)
     */
    private $getOrderSn;

    /**
     * 获取优惠券的时间
     * @ORM\Column(name="get_time", type="integer", length=10)
     */
    private $getTime;

    /**
     * 优惠券id
     * @ORM\Column(name="coupon_id", type="integer", length=11)
     */
    private $couponId;

    /**
     * 优惠券名称
     * @ORM\Column(name="coupon_title", type="string", length=150)
     */
    private $couponTitle;

    /**
     * 优惠券描述
     * @ORM\Column(name="coupon_info", type="string", length=300)
     */
    private $couponInfo;

    /**
     * 优惠券可用的开始时间
     * @ORM\Column(name="coupon_use_start_time", type="integer", length=10)
     */
    private $couponUseStartTime = 0;

    /**
     * 优惠券可用的结束时间
     * @ORM\Column(name="coupon_use_end_time", type="integer", length=10)
     */
    private $couponUseEndTime = 0;

    /**
     * @return mixed
     */
    public function getUserCouponId()
    {
        return $this->userCouponId;
    }

    /**
     * @param mixed $userCouponId
     */
    public function setUserCouponId($userCouponId): void
    {
        $this->userCouponId = $userCouponId;
    }

    /**
     * @return mixed
     */
    public function getCouponUseState()
    {
        return $this->couponUseState;
    }

    /**
     * @param mixed $couponUseState
     */
    public function setCouponUseState($couponUseState): void
    {
        $this->couponUseState = $couponUseState;
    }

    /**
     * @return mixed
     */
    public function getUserId()
    {
        return $this->userId;
    }

    /**
     * @param mixed $userId
     */
    public function setUserId($userId): void
    {
        $this->userId = $userId;
    }

    /**
     * @return mixed
     */
    public function getUserName()
    {
        return $this->userName;
    }

    /**
     * @param mixed $userName
     */
    public function setUserName($userName): void
    {
        $this->userName = $userName;
    }

    /**
     * @return mixed
     */
    public function getUsedOrderId()
    {
        return $this->usedOrderId;
    }

    /**
     * @param mixed $usedOrderId
     */
    public function setUsedOrderId($usedOrderId): void
    {
        $this->usedOrderId = $usedOrderId;
    }

    /**
     * @return mixed
     */
    public function getUsedOrderSn()
    {
        return $this->usedOrderSn;
    }

    /**
     * @param mixed $usedOrderSn
     */
    public function setUsedOrderSn($usedOrderSn): void
    {
        $this->usedOrderSn = $usedOrderSn;
    }

    /**
     * @return mixed
     */
    public function getUsedTime()
    {
        return $this->usedTime;
    }

    /**
     * @param mixed $usedTime
     */
    public function setUsedTime($usedTime): void
    {
        $this->usedTime = $usedTime;
    }

    /**
     * @return mixed
     */
    public function getGetOrderId()
    {
        return $this->getOrderId;
    }

    /**
     * @param mixed $getOrderId
     */
    public function setGetOrderId($getOrderId): void
    {
        $this->getOrderId = $getOrderId;
    }

    /**
     * @return mixed
     */
    public function getGetOrderSn()
    {
        return $this->getOrderSn;
    }

    /**
     * @param mixed $getOrderSn
     */
    public function setGetOrderSn($getOrderSn): void
    {
        $this->getOrderSn = $getOrderSn;
    }

    /**
     * @return mixed
     */
    public function getGetTime()
    {
        return $this->getTime;
    }

    /**
     * @param mixed $getTime
     */
    public function setGetTime($getTime): void
    {
        $this->getTime = $getTime;
    }

    /**
     * @return mixed
     */
    public function getCouponId()
    {
        return $this->couponId;
    }

    /**
     * @param mixed $couponId
     */
    public function setCouponId($couponId): void
    {
        $this->couponId = $couponId;
    }

    /**
     * @return mixed
     */
    public function getCouponTitle()
    {
        return $this->couponTitle;
    }

    /**
     * @param mixed $couponTitle
     */
    public function setCouponTitle($couponTitle): void
    {
        $this->couponTitle = $couponTitle;
    }

    /**
     * @return mixed
     */
    public function getCouponInfo()
    {
        return $this->couponInfo;
    }

    /**
     * @param mixed $couponInfo
     */
    public function setCouponInfo($couponInfo): void
    {
        $this->couponInfo = $couponInfo;
    }

    /**
     * @return mixed
     */
    public function getCouponUseStartTime()
    {
        return $this->couponUseStartTime;
    }

    /**
     * @param mixed $couponUseStartTime
     */
    public function setCouponUseStartTime($couponUseStartTime): void
    {
        $this->couponUseStartTime = $couponUseStartTime;
    }

    /**
     * @return mixed
     */
    public function getCouponUseEndTime()
    {
        return $this->couponUseEndTime;
    }

    /**
     * @param mixed $couponUseEndTime
     */
    public function setCouponUseEndTime($couponUseEndTime): void
    {
        $this->couponUseEndTime = $couponUseEndTime;
    }
}