<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Operation\Event\Factory;

use Admin\Data\Config;
use Interop\Container\ContainerInterface;
use Laminas\I18n\Translator\Translator;
use Laminas\ServiceManager\Factory\FactoryInterface;
use Operation\Event\OperationListener;
use Operation\Service\UserCouponManager;

class OperationListenerFactory implements FactoryInterface
{
    public function __invoke(ContainerInterface $container, $requestedName, array $options = null)
    {
        $entityManager      = $container->get(Config::SHOP_DATABASE_MANAGER_WRITE);
        $userCouponManager  = $container->get(UserCouponManager::class);

        return new OperationListener($entityManager, $userCouponManager);
    }
}