<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Operation\Form;

use Admin\Data\Common;
use Admin\Data\Config;
use Admin\Filter\OldImage;
use Laminas\Form\Form;

class AdSlideForm extends Form
{
    private $imageArray;

    public function __construct($imageArray = [], $name = 'mobile-ad-edit-form', $options = [])
    {
        parent::__construct($name, $options);
        $this->setAttribute('method', 'post');
        $this->setAttribute('class', 'form-horizontal');

        $this->imageArray = $imageArray;

        $this->addElements();
        $this->addInputFilter();
    }

    protected function addElements()
    {
        $this->add([
            'type'  => 'file',
            'name'  => 'slideImage1',
            'attributes'    => [
                'id'    => 'slideImage1',
                'class' => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'hidden',
            'name'  => 'slideId1',
            'attributes'    => [
                'id'    => 'slideId1',
                'class' => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'slideUrl1',
            'attributes'    => [
                'id'    => 'slideUrl1',
                'class' => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'number',
            'name'  => 'slideSort1',
            'attributes'    => [
                'id'            => 'slideSort1',
                'class'         => 'form-control',
                'value'         => 255
            ]
        ]);

        $this->add([
            'type'  => 'file',
            'name'  => 'slideImage2',
            'attributes'    => [
                'id'    => 'slideImage2',
                'class' => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'hidden',
            'name'  => 'slideId2',
            'attributes'    => [
                'id'    => 'slideId2',
                'class' => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'slideUrl2',
            'attributes'    => [
                'id'    => 'slideUrl2',
                'class' => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'number',
            'name'  => 'slideSort2',
            'attributes'    => [
                'id'            => 'slideSort2',
                'class'         => 'form-control',
                'value'         => 255
            ]
        ]);

        $this->add([
            'type'  => 'file',
            'name'  => 'slideImage3',
            'attributes'    => [
                'id'    => 'slideImage3',
                'class' => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'hidden',
            'name'  => 'slideId3',
            'attributes'    => [
                'id'    => 'slideId3',
                'class' => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'slideUrl3',
            'attributes'    => [
                'id'    => 'slideUrl3',
                'class' => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'number',
            'name'  => 'slideSort3',
            'attributes'    => [
                'id'            => 'slideSort3',
                'class'         => 'form-control',
                'value'         => 255
            ]
        ]);

        $this->add([
            'type'  => 'file',
            'name'  => 'slideImage4',
            'attributes'    => [
                'id'    => 'slideImage4',
                'class' => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'hidden',
            'name'  => 'slideId4',
            'attributes'    => [
                'id'    => 'slideId4',
                'class' => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'slideUrl4',
            'attributes'    => [
                'id'    => 'slideUrl4',
                'class' => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'number',
            'name'  => 'slideSort4',
            'attributes'    => [
                'id'            => 'slideSort4',
                'class'         => 'form-control',
                'value'         => 255
            ]
        ]);

        $this->add([
            'type'  => 'file',
            'name'  => 'slideImage5',
            'attributes'    => [
                'id'    => 'slideImage5',
                'class' => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'hidden',
            'name'  => 'slideId5',
            'attributes'    => [
                'id'    => 'slideId5',
                'class' => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'slideUrl5',
            'attributes'    => [
                'id'    => 'slideUrl5',
                'class' => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'number',
            'name'  => 'slideSort5',
            'attributes'    => [
                'id'            => 'slideSort5',
                'class'         => 'form-control',
                'value'         => 255
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'adStartTime',
            'attributes'    => [
                'id'    => 'adStartTime',
                'class' => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'adEndTime',
            'attributes'    => [
                'id'    => 'adEndTime',
                'class' => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'checkbox',
            'name'  => 'adState',
            'attributes'    => [
                'id'    => 'adState',
                'value' => 1
            ]
        ]);
    }

    protected function addInputFilter()
    {
        $inputFilter = $this->getInputFilter();

        $inputFilter->add([
            'type'      => 'Laminas\InputFilter\FileInput',
            'name'      => 'slideImage1',
            'required'  => false,
            'validators'=> [
                ['name' => 'FileUploadFile'],
                [
                    'name' => 'FileMimeType',
                    'options' => [
                        'mimeType' => Common::configValue('image_type')
                    ]
                ],
                ['name' => 'FileIsImage'],
                [
                    'name' => 'FileSize',
                    'options' => Common::configValue('upload_image_max')
                ]
            ],
            'filters'  => [
                [
                    'name' => 'FileRenameUpload',
                    'options' => [
                        'target' => Config::AD_IMAGE_PATH,
                        'useUploadName'=>true,
                        'useUploadExtension'=>true,
                        'overwrite'=>true,
                        'randomize'=>true
                    ]
                ],
                [
                    'name' => OldImage::class,
                    'options' => [
                        'oldImage' => isset($this->imageArray['slideImage1']) ? $this->imageArray['slideImage1'] : ''
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'slideId1',
            'required'  => false,
            'filters'   => [
                ['name' => 'ToInt']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'slideUrl1',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'slideSort1',
            'required'  => true,
            'filters'   => [
                ['name' => 'ToInt']
            ],
            'validators'=> [
                [
                    'name'      => 'GreaterThan',
                    'options'   => [
                        'min'   => 0
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'type'      => 'Laminas\InputFilter\FileInput',
            'name'      => 'slideImage2',
            'required'  => false,
            'validators'=> [
                ['name' => 'FileUploadFile'],
                [
                    'name' => 'FileMimeType',
                    'options' => [
                        'mimeType' => Common::configValue('image_type')
                    ]
                ],
                ['name' => 'FileIsImage'],
                [
                    'name' => 'FileSize',
                    'options' => Common::configValue('upload_image_max')
                ]
            ],
            'filters'  => [
                [
                    'name' => 'FileRenameUpload',
                    'options' => [
                        'target' => Config::AD_IMAGE_PATH,
                        'useUploadName'=>true,
                        'useUploadExtension'=>true,
                        'overwrite'=>true,
                        'randomize'=>true
                    ]
                ],
                [
                    'name' => OldImage::class,
                    'options' => [
                        'oldImage' => isset($this->imageArray['slideImage2']) ? $this->imageArray['slideImage2'] : ''
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'slideId2',
            'required'  => false,
            'filters'   => [
                ['name' => 'ToInt']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'slideUrl2',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'slideSort2',
            'required'  => true,
            'filters'   => [
                ['name' => 'ToInt']
            ],
            'validators'=> [
                [
                    'name'      => 'GreaterThan',
                    'options'   => [
                        'min'   => 0
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'type'      => 'Laminas\InputFilter\FileInput',
            'name'      => 'slideImage3',
            'required'  => false,
            'validators'=> [
                ['name' => 'FileUploadFile'],
                [
                    'name' => 'FileMimeType',
                    'options' => [
                        'mimeType' => Common::configValue('image_type')
                    ]
                ],
                ['name' => 'FileIsImage'],
                [
                    'name' => 'FileSize',
                    'options' => Common::configValue('upload_image_max')
                ]
            ],
            'filters'  => [
                [
                    'name' => 'FileRenameUpload',
                    'options' => [
                        'target' => Config::AD_IMAGE_PATH,
                        'useUploadName'=>true,
                        'useUploadExtension'=>true,
                        'overwrite'=>true,
                        'randomize'=>true
                    ]
                ],
                [
                    'name' => OldImage::class,
                    'options' => [
                        'oldImage' => isset($this->imageArray['slideImage3']) ? $this->imageArray['slideImage3'] : ''
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'slideId3',
            'required'  => false,
            'filters'   => [
                ['name' => 'ToInt']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'slideUrl3',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'slideSort3',
            'required'  => true,
            'filters'   => [
                ['name' => 'ToInt']
            ],
            'validators'=> [
                [
                    'name'      => 'GreaterThan',
                    'options'   => [
                        'min'   => 0
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'type'      => 'Laminas\InputFilter\FileInput',
            'name'      => 'slideImage4',
            'required'  => false,
            'validators'=> [
                ['name' => 'FileUploadFile'],
                [
                    'name' => 'FileMimeType',
                    'options' => [
                        'mimeType' => Common::configValue('image_type')
                    ]
                ],
                ['name' => 'FileIsImage'],
                [
                    'name' => 'FileSize',
                    'options' => Common::configValue('upload_image_max')
                ]
            ],
            'filters'  => [
                [
                    'name' => 'FileRenameUpload',
                    'options' => [
                        'target' => Config::AD_IMAGE_PATH,
                        'useUploadName'=>true,
                        'useUploadExtension'=>true,
                        'overwrite'=>true,
                        'randomize'=>true
                    ]
                ],
                [
                    'name' => OldImage::class,
                    'options' => [
                        'oldImage' => isset($this->imageArray['slideImage4']) ? $this->imageArray['slideImage4'] : ''
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'slideId4',
            'required'  => false,
            'filters'   => [
                ['name' => 'ToInt']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'slideUrl4',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'slideSort4',
            'required'  => true,
            'filters'   => [
                ['name' => 'ToInt']
            ],
            'validators'=> [
                [
                    'name'      => 'GreaterThan',
                    'options'   => [
                        'min'   => 0
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'type'      => 'Laminas\InputFilter\FileInput',
            'name'      => 'slideImage5',
            'required'  => false,
            'validators'=> [
                ['name' => 'FileUploadFile'],
                [
                    'name' => 'FileMimeType',
                    'options' => [
                        'mimeType' => Common::configValue('image_type')
                    ]
                ],
                ['name' => 'FileIsImage'],
                [
                    'name' => 'FileSize',
                    'options' => Common::configValue('upload_image_max')
                ]
            ],
            'filters'  => [
                [
                    'name' => 'FileRenameUpload',
                    'options' => [
                        'target' => Config::AD_IMAGE_PATH,
                        'useUploadName'=>true,
                        'useUploadExtension'=>true,
                        'overwrite'=>true,
                        'randomize'=>true
                    ]
                ],
                [
                    'name' => OldImage::class,
                    'options' => [
                        'oldImage' => isset($this->imageArray['slideImage5']) ? $this->imageArray['slideImage5'] : ''
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'slideId5',
            'required'  => false,
            'filters'   => [
                ['name' => 'ToInt']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'slideUrl5',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'slideSort5',
            'required'  => true,
            'filters'   => [
                ['name' => 'ToInt']
            ],
            'validators'=> [
                [
                    'name'      => 'GreaterThan',
                    'options'   => [
                        'min'   => 0
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'adStartTime',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'adEndTime',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'adState',
            'required'  => false,
            'validators'=> [
                [
                    'name'      => 'InArray',
                    'options'   => [
                        'haystack'  => [0, 1]
                    ]
                ]
            ]
        ]);
    }
}