<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Operation\Form;

use Laminas\Form\Form;

class CouponForm extends Form
{
    public function __construct($name = 'coupon-form', $options = [])
    {
        parent::__construct($name, $options);

        $this->setAttribute('method', 'post');
        $this->setAttribute('class', 'form-horizontal');

        $this->addElements();
        $this->addInputFilter();
    }

    protected function addElements()
    {
        $this->add([
            'type'  => 'text',
            'name'  => 'couponTitle',
            'attributes'    => [
                'id'    => 'couponTitle',
                'class' => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'couponInfo',
            'attributes'    => [
                'id'    => 'couponInfo',
                'class' => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'couponStartTime',
            'attributes'    => [
                'id'    => 'couponStartTime',
                'class' => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'couponEndTime',
            'attributes'    => [
                'id'    => 'couponEndTime',
                'class' => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'checkbox',
            'name'  => 'couponState',
            'attributes'    => [
                'id'    => 'couponState',
                'value' => 1
            ]
        ]);

        $this->add([
            'type'  => 'number',
            'name'  => 'shoppingAmount',
            'attributes'    => [
                'id'    => 'shoppingAmount',
                'class' => 'form-control',
                'value' => 1,
                'min'   => 1
            ]
        ]);

        $this->add([
            'type'  => 'number',
            'name'  => 'shoppingDiscount',
            'attributes'    => [
                'id'    => 'shoppingDiscount',
                'class' => 'form-control',
                'value' => 1,
                'min'   => 1
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'getCouponStartTime',
            'attributes'    => [
                'id'    => 'getCouponStartTime',
                'class' => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'getCouponEndTime',
            'attributes'    => [
                'id'    => 'getCouponEndTime',
                'class' => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'select',
            'name'  => 'getCouponType',
            'attributes'    => [
                'id'    => 'getCouponType',
                'class' => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'number',
            'name'  => 'getShoppingAmount',
            'attributes'    => [
                'id'    => 'getShoppingAmount',
                'class' => 'form-control',
                'value' => 1,
                'min'   => 1
            ]
        ]);

        $this->add([
            'type'  => 'number',
            'name'  => 'userGetFrequency',
            'attributes'    => [
                'id'    => 'userGetFrequency',
                'class' => 'form-control',
                'min'   => 1,
                'value' => 1
            ]
        ]);

        $this->add([
            'type'  => 'select',
            'name'  => 'getUserType',
            'attributes'    => [
                'id'    => 'getUserType',
                'class' => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'multiCheckbox',
            'name'  => 'userGroup',
            'options'    => [
                'label_attributes' => [
                    'class' => 'checkbox-inline'
                ]
            ]
        ]);

        $this->add([
            'type'  => 'select',
            'name'  => 'getGoodsType',
            'attributes'    => [
                'id'    => 'getGoodsType',
                'class' => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'multiCheckbox',
            'name'  => 'goodsClass'
        ]);

        $this->add([
            'type'  => 'multiCheckbox',
            'name'  => 'goodsBrand'
        ]);
    }

    protected function addInputFilter()
    {
        $inputFilter = $this->getInputFilter();

        $inputFilter->add([
            'name'      => 'couponTitle',
            'required'  => true,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'couponInfo',
            'required'  => true,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'couponStartTime',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'couponEndTime',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'couponState',
            'required'  => false,
            'validators'=> [
                [
                    'name'      => 'InArray',
                    'options'   => [
                        'haystack'  => [0, 1]
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'shoppingAmount',
            'required'  => true,
            'filters'   => [
                ['name' => 'ToInt']
            ],
            'validators'=> [
                [
                    'name'      => 'GreaterThan',
                    'options'   => [
                        'min'   => 0
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'shoppingDiscount',
            'required'  => true,
            'filters'   => [
                ['name' => 'ToInt']
            ],
            'validators'=> [
                [
                    'name'      => 'GreaterThan',
                    'options'   => [
                        'min'   => 0
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'getCouponStartTime',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'getCouponEndTime',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'getCouponType',
            'required'  => false
        ]);

        $inputFilter->add([
            'name'      => 'getShoppingAmount',
            'required'  => false,
            'filters'   => [
                ['name' => 'ToInt']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'userGetFrequency',
            'required'  => false,
            'filters'   => [
                ['name' => 'ToInt']
            ],
            'validators'=> [
                [
                    'name'      => 'GreaterThan',
                    'options'   => [
                        'min'   => 0
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'userGroup',
            'required'  => false,
            'filters'   => [
                ['name' => 'ToInt']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'goodsClass',
            'required'  => false,
            'filters'   => [
                ['name' => 'ToInt']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'goodsBrand',
            'required'  => false,
            'filters'   => [
                ['name' => 'ToInt']
            ]
        ]);
    }
}