<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Operation\Form;

use Admin\Data\Config;
use Laminas\Form\Form;

class CreateRechargeCodeForm extends Form
{
    public function __construct($name = 'create-recharge-code-form', $options = [])
    {
        parent::__construct($name, $options);
        $this->setAttribute('method', 'post');
        $this->setAttribute('class', 'form-horizontal');

        $this->addElements();
        $this->addInputFilter();
    }

    protected function addElements()
    {
        $this->add([
            'type'  => 'number',
            'name'  => 'codeNum',
            'attributes'    => [
                'id'    => 'codeNum',
                'class' => 'form-control',
                'value' => 50,
                'min'   => 1,
                'max'   => Config::CREATE_RECHARGE_CODE_MAX_NUM
            ]
        ]);
    }

    protected function addInputFilter()
    {
        $inputFilter = $this->getInputFilter();

        $inputFilter->add([
            'name'      => 'codeNum',
            'required'  => true,
            'filters'   => [
                ['name' => 'ToInt']
            ],
            'validators'=> [
                [
                    'name'      => 'GreaterThan',
                    'options'   => [
                        'min'   => 0,
                        'max'   => Config::CREATE_RECHARGE_CODE_MAX_NUM
                    ]
                ]
            ]
        ]);
    }
}