<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Operation\Form;

use Laminas\Form\Form;

class DiscountRuleForm extends Form
{
    public function __construct($name = 'discount-rule-form', $options = [])
    {
        parent::__construct($name, $options);

        $this->setAttribute('method', 'post');
        $this->setAttribute('class', 'form-horizontal');

        $this->addElements();
        $this->addInputFilter();
    }

    protected function addElements()
    {
        $this->add([
            'type'  => 'text',
            'name'  => 'discountRuleTitle',
            'attributes'    => [
                'id'    => 'discountRuleTitle',
                'class' => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'discountRuleInfo',
            'attributes'    => [
                'id'    => 'discountRuleInfo',
                'class' => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'discountStartTime',
            'attributes'    => [
                'id'    => 'discountStartTime',
                'class' => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'discountEndTime',
            'attributes'    => [
                'id'    => 'discountEndTime',
                'class' => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'number',
            'name'  => 'userBuyFrequency',
            'attributes'    => [
                'id'    => 'userBuyFrequency',
                'class' => 'form-control',
                'min'   => 0,
                'value' => 1
            ]
        ]);

        $this->add([
            'type'  => 'checkbox',
            'name'  => 'discountState',
            'attributes'    => [
                'id'    => 'discountState',
                'value' => 1
            ]
        ]);

        $this->add([
            'type'  => 'select',
            'name'  => 'goodsBuyType',
            'attributes'    => [
                'id'    => 'goodsBuyType',
                'class' => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'number',
            'name'  => 'goodsBuyAmount',
            'attributes'    => [
                'id'    => 'goodsBuyAmount',
                'class' => 'form-control',
                'min'   => 0
            ]
        ]);

        $this->add([
            'type'  => 'number',
            'name'  => 'buyDiscount',
            'attributes'    => [
                'id'    => 'buyDiscount',
                'class' => 'form-control',
                'min'   => 0
            ]
        ]);

        $this->add([
            'type'  => 'select',
            'name'  => 'discountMode',
            'attributes'    => [
                'id'            => 'discountMode',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'select',
            'name'  => 'discountUserType',
            'attributes'    => [
                'id'            => 'discountUserType',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'multiCheckbox',
            'name'  => 'userGroup',
            'options'    => [
                'label_attributes' => [
                    'class' => 'checkbox-inline'
                ]
            ]
        ]);

        $this->add([
            'type'  => 'select',
            'name'  => 'discountGoodsType',
            'attributes'    => [
                'id'            => 'discountGoodsType',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'multiCheckbox',
            'name'  => 'goodsClass'
        ]);

        $this->add([
            'type'  => 'multiCheckbox',
            'name'  => 'goodsBrand'
        ]);
    }

    protected function addInputFilter()
    {
        $inputFilter = $this->getInputFilter();

        $inputFilter->add([
            'name'      => 'discountRuleTitle',
            'required'  => true,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'discountRuleInfo',
            'required'  => true,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'discountStartTime',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'discountEndTime',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'discountState',
            'required'  => false,
            'validators'=> [
                [
                    'name'      => 'InArray',
                    'options'   => [
                        'haystack'  => [0, 1]
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'goodsBuyAmount',
            'required'  => true,
            'filters'   => [
                ['name' => 'ToInt']
            ],
            'validators'=> [
                [
                    'name'      => 'GreaterThan',
                    'options'   => [
                        'min'   => 0,
                        'inclusive' => true
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'buyDiscount',
            'required'  => true,
            'filters'   => [
                ['name' => 'ToInt']
            ],
            'validators'=> [
                [
                    'name'      => 'GreaterThan',
                    'options'   => [
                        'min'   => 0,
                        'inclusive' => true
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'userGroup',
            'required'  => false,
            'filters'   => [
                ['name' => 'ToInt']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'goodsClass',
            'required'  => false,
            'filters'   => [
                ['name' => 'ToInt']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'goodsBrand',
            'required'  => false,
            'filters'   => [
                ['name' => 'ToInt']
            ]
        ]);
    }
}