<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Operation\Form;

use Admin\Data\Config;
use Laminas\Form\Form;

class RechargeCodeRuleForm extends Form
{
    private $editState;

    public function __construct($editState = false, $name = 'recharge-code-form', $options = [])
    {
        parent::__construct($name, $options);
        $this->setAttribute('method', 'post');
        $this->setAttribute('class', 'form-horizontal');

        $this->editState = $editState;

        $this->addElements();
        $this->addInputFilter();
    }

    protected function addElements()
    {
        $this->add([
            'type'  => 'text',
            'name'  => 'codeRuleTitle',
            'attributes'    => [
                'id'    => 'codeRuleTitle',
                'class' => 'form-control'
            ]
        ]);

        if (!$this->editState) {
            $this->add([
                'type'  => 'text',
                'name'  => 'codeOneMoney',
                'attributes'    => [
                    'id'    => 'codeOneMoney',
                    'class' => 'form-control'
                ]
            ]);

            $this->add([
                'type'  => 'number',
                'name'  => 'codeNum',
                'attributes'    => [
                    'id'    => 'codeNum',
                    'class' => 'form-control',
                    'value' => 50,
                    'min'   => 1,
                    'max'   => Config::CREATE_RECHARGE_CODE_MAX_NUM
                ]
            ]);
        }

        $this->add([
            'type'  => 'text',
            'name'  => 'codeStartTime',
            'attributes'    => [
                'id'    => 'codeStartTime',
                'class' => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'codeEndTime',
            'attributes'    => [
                'id'    => 'codeEndTime',
                'class' => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'checkbox',
            'name'  => 'codeRuleState',
            'attributes'    => [
                'id'    => 'codeRuleState'
            ]
        ]);
    }

    protected function addInputFilter()
    {
        $inputFilter = $this->getInputFilter();

        $inputFilter->add([
            'name'      => 'codeRuleTitle',
            'required'  => true,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        if (!$this->editState) {
            $inputFilter->add([
                'name'      => 'codeOneMoney',
                'required'  => false,
                'filters'   => [
                    ['name' => 'ToFloat']
                ],
                'validators'=> [
                    [
                        'name'      => 'GreaterThan',
                        'options'   => [
                            'min'   => 0
                        ]
                    ]
                ]
            ]);

            $inputFilter->add([
                'name'      => 'codeNum',
                'required'  => true,
                'filters'   => [
                    ['name' => 'ToInt']
                ],
                'validators'=> [
                    [
                        'name'      => 'GreaterThan',
                        'options'   => [
                            'min'   => 0,
                            'max'   => Config::CREATE_RECHARGE_CODE_MAX_NUM
                        ]
                    ]
                ]
            ]);
        }

        $inputFilter->add([
            'name'      => 'codeStartTime',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'codeEndTime',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'codeRuleState',
            'required'  => false,
            'validators'=> [
                [
                    'name'      => 'InArray',
                    'options'   => [
                        'haystack'  => [0, 1]
                    ]
                ]
            ]
        ]);
    }
}