<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Operation\Form;

use Laminas\Form\Form;
use Laminas\I18n\Translator\Translator;

class SearchUserCouponForm extends Form
{
    private $translator;
    private $couponInfo;

    public function __construct($couponInfo, $name = 'search-user-coupon-form', $options = [])
    {
        parent::__construct($name, $options);
        $this->setAttribute('method', 'get');
        $this->setAttribute('class', 'form-horizontal');

        $this->translator = new Translator();
        $this->couponInfo = $couponInfo;

        $this->addElements();
        $this->addInputFilter();
    }

    protected function addElements()
    {
        $this->add([
            'type'  => 'text',
            'name'  => 'user_name',
            'attributes'    => [
                'id'            => 'user_name',
                'class'         => 'form-control input-sm',
                'placeholder'   => $this->translator->translate('获得者')
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'get_start_time',
            'attributes'    => [
                'id'            => 'get_start_time',
                'class'         => 'form-control input-sm',
                'placeholder'   => $this->translator->translate('起始时间')
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'get_end_time',
            'attributes'    => [
                'id'            => 'get_end_time',
                'class'         => 'form-control input-sm',
                'placeholder'   => $this->translator->translate('结束时间')
            ]
        ]);

        if ($this->couponInfo->getGetCouponType() == 'buy') {
            $this->add([
                'type'  => 'text',
                'name'  => 'get_order_sn',
                'attributes'    => [
                    'id'            => 'get_order_sn',
                    'class'         => 'form-control input-sm',
                    'placeholder'   => $this->translator->translate('订单编号')
                ]
            ]);
        }

        $this->add([
            'type'  => 'select',
            'name'  => 'coupon_use_state',
            'attributes'    => [
                'id'            => 'coupon_use_state',
                'class'         => 'form-control input-sm'
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'use_order_sn',
            'attributes'    => [
                'id'            => 'use_order_sn',
                'class'         => 'form-control input-sm',
                'placeholder'   => $this->translator->translate('订单编号')
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'use_start_time',
            'attributes'    => [
                'id'            => 'use_start_time',
                'class'         => 'form-control input-sm',
                'placeholder'   => $this->translator->translate('起始时间')
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'use_end_time',
            'attributes'    => [
                'id'            => 'use_end_time',
                'class'         => 'form-control input-sm',
                'placeholder'   => $this->translator->translate('结束时间')
            ]
        ]);
    }

    protected function addInputFilter()
    {
        $inputFilter = $this->getInputFilter();

        $inputFilter->add([
            'name'      => 'user_name',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'get_start_time',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'get_end_time',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags']
            ]
        ]);

        if ($this->couponInfo->getGetCouponType() == 'buy') {
            $inputFilter->add([
                'name'      => 'get_order_sn',
                'required'  => false,
                'filters'   => [
                    ['name' => 'StringTrim'],
                    ['name' => 'StripTags'],
                    ['name' => 'HtmlEntities']
                ]
            ]);
        }

        $inputFilter->add([
            'name'      => 'coupon_use_state',
            'required'  => false
        ]);

        $inputFilter->add([
            'name'      => 'use_order_sn',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'use_start_time',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'use_end_time',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags']
            ]
        ]);
    }
}