<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Operation\Repository\QuerySearch;

use Doctrine\ORM\QueryBuilder;

class UserCouponSearch
{
    /**
     * 后台会员优惠券搜索
     * @param $search
     * @param QueryBuilder $queryBuilder
     * @return QueryBuilder
     */
    public static function querySearchData($search, QueryBuilder $queryBuilder)
    {
        if(isset($search['user_name']) && !empty($search['user_name']))             $queryBuilder->andWhere($queryBuilder->expr()->eq('c.userName', ':userName'))->setParameter('userName', $search['user_name']);
        if(isset($search['get_start_time']) && !empty($search['get_start_time']))   $queryBuilder->andWhere($queryBuilder->expr()->gte('c.getTime', ':getStartTime'))->setParameter('getStartTime', strtotime($search['get_start_time'].' 00:00:00'));
        if(isset($search['get_end_time']) && !empty($search['get_end_time']))       $queryBuilder->andWhere($queryBuilder->expr()->lte('c.getTime', ':getEndTime'))->setParameter('getEndTime', strtotime($search['get_end_time'].' 23:59:59'));

        if(isset($search['coupon_use_state']) && is_numeric($search['coupon_use_state']) && $search['coupon_use_state'] >= 0) {
            $queryBuilder->andWhere($queryBuilder->expr()->eq('c.couponUseState', ':couponUseState'))->setParameter('couponUseState', $search['coupon_use_state']);
        }

        if(isset($search['get_order_sn']) && !empty($search['get_order_sn']))       $queryBuilder->andWhere($queryBuilder->expr()->eq('c.getOrderSn', ':getOrderSn'))->setParameter('getOrderSn', $search['get_order_sn']);
        if(isset($search['use_order_sn']) && !empty($search['use_order_sn']))       $queryBuilder->andWhere($queryBuilder->expr()->eq('c.usedOrderSn', ':useOrderSn'))->setParameter('useOrderSn', $search['use_order_sn']);

        if(isset($search['use_start_time']) && !empty($search['use_start_time']))   $queryBuilder->andWhere($queryBuilder->expr()->gte('c.usedTime', ':usedStartTime'))->setParameter('usedStartTime', strtotime($search['use_start_time'].' 00:00:00'));
        if(isset($search['use_end_time']) && !empty($search['use_end_time']))       $queryBuilder->andWhere($queryBuilder->expr()->lte('c.usedTime', ':usedEndTime'))->setParameter('usedEndTime', strtotime($search['use_end_time'].' 23:59:59'));

        return $queryBuilder;
    }

    /**
     * 前台会员优惠券搜索
     * @param $search
     * @param QueryBuilder $queryBuilder
     * @return QueryBuilder
     */
    public static function shopQuerySearchData($search, QueryBuilder $queryBuilder)
    {
        if (empty($search)) return $queryBuilder;

        if(isset($search['coupon_use_state']) && is_numeric($search['coupon_use_state']) && $search['coupon_use_state'] >= 0) {
            $queryBuilder->andWhere($queryBuilder->expr()->eq('c.couponUseState', ':couponUseState'))->setParameter('couponUseState', $search['coupon_use_state']);
        }

        return $queryBuilder;
    }
}