<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Operation\Repository;

use Doctrine\ORM\EntityRepository;
use Operation\Entity\RechargeCode;

class RechargeCodeRepository extends EntityRepository
{
    /**
     * 导出数据
     * @param $codeRuleId
     * @param $codeState
     * @return int|mixed|string
     */
    public function findExportRechargeCode($codeRuleId, $codeState)
    {
        $query = $this->getEntityManager()->createQueryBuilder();
        $query->select('o')
            ->from(RechargeCode::class, 'o')
            ->where('o.codeRuleId = :codeRuleId')->setParameter('codeRuleId', $codeRuleId)
            ->orderBy('o.codeId', 'DESC');

        if ($codeState == 2) {
            $query->andWhere('o.userId = 0');
        } elseif ($codeState == 3) {
            $query->andWhere('o.userId > 0');
        }

        return $query->getQuery()->getResult();
    }
}