<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Operation\Repository;

use Doctrine\ORM\EntityRepository;
use Operation\Entity\RechargeCode;
use Operation\Entity\RechargeCodeRule;

class RechargeCodeRuleRepository extends EntityRepository
{
    /**
     * 充值码规则列表
     * @return int|mixed|string
     */
    public function findRechargeCodeRuleList()
    {
        $query = $this->getEntityManager()->createQueryBuilder();
        $query->select('r')
            ->addSelect('(SELECT COUNT(c.codeId) FROM '.RechargeCode::class.' AS c WHERE c.codeRuleId=r.codeRuleId AND c.userId > 0) AS useCodeNum')
            ->from(RechargeCodeRule::class, 'r')->orderBy('r.codeRuleId', 'DESC');

        return $query->getQuery()->getResult();
    }
}