<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Operation\Repository;

use Doctrine\ORM\EntityRepository;
use Doctrine\ORM\Query\Expr\Join;
use Operation\Entity\Coupon;
use Operation\Entity\UserCoupon;
use Operation\Repository\QuerySearch\UserCouponSearch;
use function Doctrine\ORM\QueryBuilder;

class UserCouponRepository extends EntityRepository
{
    /**
     * 后台会员优惠券列表
     * @param $couponId
     * @param array $search
     * @return \Doctrine\ORM\Query
     */
    public function findUserCouponList($couponId, array $search = [])
    {
        $query = $this->getEntityManager()->createQueryBuilder();
        $query->select('c')
            ->from(UserCoupon::class, 'c')
            ->where('c.couponId = :couponId')->setParameter('couponId', $couponId)
            ->orderBy('c.userCouponId', 'DESC');

        $query = UserCouponSearch::querySearchData($search, $query);

        return $query->getQuery();
    }
    /*=======================================下面为前台使用=======================================*/
    /**
     * 前台会员优惠券列表
     * @param $userId
     * @param array $search
     * @return \Doctrine\ORM\Query
     */
    public function shopUserCouponList($userId, array $search = [])
    {
        $query = $this->getEntityManager()->createQueryBuilder();
        $query->select('c')
            ->from(UserCoupon::class, 'c')
            ->where('c.userId = :userId')->setParameter('userId', $userId)
            ->orderBy('c.userCouponId', 'DESC');

        $query = UserCouponSearch::shopQuerySearchData($search, $query);

        return $query->getQuery();
    }

    /**
     * 获取购物时可以使用的优惠券
     * @param $userId
     * @param array $couponIdArray
     * @return int|mixed|string
     */
    public function checkoutUserCouponList($userId, array $couponIdArray)
    {
        $query = $this->getEntityManager()->createQueryBuilder();
        $query->select('c', 'p.couponTitle', 'p.couponInfo', 'p.shoppingDiscount')
            ->from(UserCoupon::class, 'c')
            ->innerJoin(Coupon::class, 'p', Join::WITH, 'c.couponId = p.couponId')
            ->where('c.userId = :userId')->setParameter('userId', $userId)
            ->andWhere('c.couponUseState = :useState')->setParameter('useState', 1)
            ->andWhere($query->expr()->in('c.couponId', $couponIdArray))
            ->orderBy('p.shoppingDiscount', 'DESC');

        return $query->getQuery()->getResult();
    }

    /**
     * 查看过期
     * @return int|mixed|string
     */
    public function notUsedCouponList()
    {
        $query = $this->getEntityManager()->createQueryBuilder();
        $query->select('uc')
            ->from(UserCoupon::class, 'uc')
            ->where('uc.couponUseEndTime > 0')
            ->andWhere('uc.couponUseEndTime <= :nowTime')->setParameter('nowTime', time())
            ->andWhere('uc.couponUseState <= 1')
            ->andWhere('uc.usedOrderId = 0');

        return $query->getQuery()->getResult();
    }
}