<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Operation\Service;

use Admin\Data\Config;
use Doctrine\ORM\EntityManager;
use Operation\Entity\AdSlide;

class AdSlideManager
{
    private $entityManager;

    public function __construct(
        EntityManager $entityManager
    )
    {
        $this->entityManager = $entityManager;
    }

    /**
     * 添加广告幻灯片
     * @param array $data
     * @param $adId
     * @return bool
     * @throws \Doctrine\Common\Persistence\Mapping\MappingException
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function addAdSlide(array $data, $adId)
    {
        for ($i = 1; $i <= 5; $i++) {
            if(!empty($data['slideImage'.$i]['tmp_name'])) $data['slideImage'.$i] = str_replace(Config::PUBLIC_PATH, '', $data['slideImage'.$i]['tmp_name']);
            else unset($data['slideImage'.$i]);

            $adSlide = new AdSlide();
            $adSlide->setAdId($adId);
            if(isset($data['slideImage'.$i])) $adSlide->setAdSlideImage($data['slideImage'.$i]);
            $adSlide->setAdSlideSort($data['slideSort'.$i]);
            $adSlide->setAdSlideUrl($data['slideUrl'.$i]);

            $this->entityManager->persist($adSlide);
            $this->entityManager->flush();
            $this->entityManager->clear(AdSlide::class);
        }

        return true;
    }

    /**
     * 编辑广告幻灯片
     * @param array $data
     * @return bool
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function editAdSlide(array $data)
    {
        for ($i = 1; $i <= 5; $i++) {
            if(!empty($data['slideImage'.$i]['tmp_name'])) $data['slideImage'.$i] = str_replace(Config::PUBLIC_PATH, '', $data['slideImage'.$i]['tmp_name']);
            else unset($data['slideImage'.$i]);

            if($data['slideId'.$i] > 0) {
                $slideInfo = $this->entityManager->getRepository(AdSlide::class)->findOneBy(['adSlideId' => $data['slideId'.$i]]);
                if($slideInfo) {
                    if(isset($data['slideImage'.$i])) $slideInfo->setAdSlideImage($data['slideImage'.$i]);
                    $slideInfo->setAdSlideSort($data['slideSort'.$i]);
                    $slideInfo->setAdSlideUrl($data['slideUrl'.$i]);
                    $this->entityManager->flush();
                }
            }
        }

        return true;
    }

    /**
     * 删除广告幻灯片
     * @param AdSlide $adSlide
     * @return bool
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function deleteAdSlide(AdSlide $adSlide)
    {
        $this->entityManager->remove($adSlide);
        $this->entityManager->flush();

        return true;
    }
}