<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Operation\Service\Common;

use Admin\Data\Common;
use Doctrine\ORM\EntityManager;
use Operation\Entity\UserCoupon;

class Coupon
{
    /**
     * 获取可用的优惠券id数组
     * data 需要调用的为 cartGoodsList
     * @param $data
     * @return array
     */
    public static function useCouponIdArray($data)
    {
        $couponConfig = Common::readConfigFile('coupon');
        $couponIdArray= [];

        if (empty($couponConfig)) return $couponIdArray;
        if (!is_array($data['cartGoodsList']) || empty($data['cartGoodsList'])) return $couponIdArray;

        foreach ($couponConfig as $configValue) {
            if (!Common::checkTime($configValue['couponStartTime'], $configValue['couponEndTime'])) continue;
            //判断使用优惠券时，不需要判断其所在组，因为在未使用时，客户可能会变更客户组
            //if (!Common::checkUser($data['userGroupId'], $configValue['getUserType'], $configValue['userGroup'])) continue;

            $costTotal = self::cartCostTotal($data['cartGoodsList'], $configValue);

            if ($costTotal >= $configValue['shoppingAmount']) {
                $couponIdArray[] = $configValue['couponId'];
            }
        }
        return $couponIdArray;
    }

    /**
     * 提交订单时，判断是否有可以获取的优惠券
     * @param $data
     * @param EntityManager $entityManager
     * @return array
     */
    public static function addOrderGetCoupon($data, EntityManager $entityManager)
    {
        $couponConfig = Common::readConfigFile('coupon');
        $couponArray= [];

        if (empty($couponConfig)) return $couponArray;
        if (!is_array($data['cartGoodsList']) || empty($data['cartGoodsList'])) return $couponArray;
        foreach ($couponConfig as $configValue) {
            if ($configValue['getCouponType'] != 'buy') continue;
            if (!Common::checkTime($configValue['getCouponStartTime'], $configValue['getCouponEndTime'])) continue;
            if (!Common::checkUser($data['userGroupId'], $configValue['getUserType'], $configValue['userGroup'])) continue;

            $costTotal = self::cartCostTotal($data['cartGoodsList'], $configValue);
            if ($costTotal >= $configValue['getShoppingAmount']) {
                $getCouponNum = $entityManager->getRepository(UserCoupon::class)->count(['userId' => $data['userId'], 'couponId' => $configValue['couponId']]);
                if (isset($configValue['userGetFrequency']) && $getCouponNum >= $configValue['userGetFrequency']) continue;

                $couponArray[] = $configValue;
            }
        }
        return $couponArray;
    }

    /**
     * 用于显示点击获取的优惠券
     * @param $data
     * @param false $idState 是否只输出ID
     * @return array
     */
    public static function clickCouponList($data, $idState = false)
    {
        $couponConfig   = Common::readConfigFile('coupon');
        $couponArray    = [];

        if (empty($couponConfig)) return $couponArray;
        foreach ($couponConfig as $configValue) {
            if ($configValue['getCouponType'] != 'click') continue;
            if (!Common::checkTime($configValue['getCouponStartTime'], $configValue['getCouponEndTime'])) continue;
            if (!Common::checkGoods($data['classId'], $configValue['getGoodsType'], $configValue['goodsBody'], $data['brandId'])) continue;
            if (
                //可以让非登录用户看到
                //!isset($data['userGroupId'])
                //|| (isset($data['userGroupId']) && empty($data['userGroupId']))
                (isset($data['userGroupId']) && $data['userGroupId'] > 0 && !Common::checkUser($data['userGroupId'], $configValue['getUserType'], $configValue['userGroup']))) continue;
            if ($idState) $couponArray[] = $configValue['couponId'];
            else $couponArray[] = $configValue;
        }

        return $couponArray;
    }

    /**
     * 购物车过滤符合条件的商品，并计算总金额
     * @param $goodsCart
     * @param $rule
     * @return float|int
     */
    private static function cartCostTotal($goodsCart, $rule)
    {
        $costTotal = 0;
        foreach ($goodsCart as $goodsValue) {
            if (Common::checkGoods($goodsValue['classId'], $rule['getGoodsType'], $rule['goodsBody'], $goodsValue['brandId'])) {
                $costTotal = $costTotal + $goodsValue['goodsAmount'];
            }
        }

        return $costTotal;
    }
}