<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Operation\Service;

use Doctrine\ORM\EntityManager;
use Operation\Entity\Coupon;

class CouponManager
{
    private $entityManager;

    public function __construct(
        EntityManager $entityManager
    )
    {
        $this->entityManager = $entityManager;
    }

    /**
     * 添加优惠券
     * @param array $data
     * @return Coupon
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function addCoupon(array $data)
    {
        $coupon = new Coupon();
        $coupon->valuesSet($data);

        $this->entityManager->persist($coupon);
        $this->entityManager->flush();

        return $coupon;
    }

    /**
     * 编辑更新优惠券
     * @param $data
     * @param Coupon $coupon
     * @return Coupon
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function editCoupon($data, Coupon $coupon)
    {
        $coupon->valuesSet($data);
        $this->entityManager->flush();

        return $coupon;
    }

    /**
     * 删除优惠券
     * @param Coupon $coupon
     * @return bool
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function deleteCoupon(Coupon $coupon)
    {
        $this->entityManager->remove($coupon);
        $this->entityManager->flush();

        return true;
    }
}