<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Operation\Service;

use Doctrine\ORM\EntityManager;
use Operation\Entity\DiscountRule;

class DiscountRuleManager
{
    private $entityManager;

    public function __construct(
        EntityManager $entityManager
    )
    {
        $this->entityManager = $entityManager;
    }

    /**
     * 添加促销规则
     * @param array $data
     * @return DiscountRule
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function addDiscountRule(array $data)
    {
        $discountRule = new DiscountRule();
        $discountRule->valuesSet($data);

        $this->entityManager->persist($discountRule);
        $this->entityManager->flush();

        return $discountRule;
    }

    /**
     * 编辑促销规则
     * @param array $data
     * @param DiscountRule $discountRule
     * @return DiscountRule
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function editDiscountRule(array $data, DiscountRule $discountRule)
    {
        $discountRule->valuesSet($data);
        $this->entityManager->flush();

        return $discountRule;
    }

    /**
     * 删除促销规则
     * @param DiscountRule $discountRule
     * @return bool
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function deletediscountRule(DiscountRule $discountRule)
    {
        $this->entityManager->remove($discountRule);
        $this->entityManager->flush();

        return true;
    }
}