<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Operation\Service;

use Doctrine\ORM\EntityManager;
use Operation\Entity\RechargeCodeRule;

class RechargeCodeRuleManager
{
    private $entityManager;

    public function __construct(
        EntityManager $entityManager
    )
    {
        $this->entityManager = $entityManager;
    }

    /**
     * 充值码规则添加
     * @param array $data
     * @return RechargeCodeRule
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function addRechargeCodeRule(array $data)
    {
        $rechargeCodeRule = new RechargeCodeRule();
        $rechargeCodeRule->valuesSet($data);
        $rechargeCodeRule->setCodeRuleAddTime(time());

        $this->entityManager->persist($rechargeCodeRule);
        $this->entityManager->flush();

        return $rechargeCodeRule;
    }

    /**
     * 编辑充值码规则
     * @param array $data
     * @param RechargeCodeRule $rechargeCodeRule
     * @return RechargeCodeRule
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function editRechargeCodeRule(array $data, RechargeCodeRule $rechargeCodeRule)
    {
        $rechargeCodeRule->valuesSet($data);
        $this->entityManager->flush();

        return $rechargeCodeRule;
    }

    /**
     * 删除充值码规则
     * @param RechargeCodeRule $rechargeCodeRule
     * @return bool
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function deleteRechargeCodeRule(RechargeCodeRule $rechargeCodeRule)
    {
        $this->entityManager->remove($rechargeCodeRule);
        $this->entityManager->flush();

        return true;
    }
}