<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Operation\View;

use Admin\Data\Common;
use Admin\Data\Config;
use Laminas\Mvc\I18n\Translator;
use Laminas\View\Helper\AbstractHelper;

class OperationHelper extends AbstractHelper
{
    private $translator;

    public function __construct(
        Translator  $translator
    )
    {
        $this->translator   = $translator;
    }

    /**
     * 促销规则状态
     * @param $state
     * @return mixed
     */
    public function ruleState($state)
    {
        $integralRuleState = Common::state($this->translator, 2);

        return $integralRuleState[$state];
    }

    /**
     * 优惠券状态
     * @param $state
     * @return mixed
     */
    public function couponState($state)
    {
        $couponState = Common::state($this->translator, 2);
        return $couponState[$state];
    }
}