<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Sales;

use Admin\Data\Config;
use Sales\Controller\Factory\IndexControllerFactory;
use Sales\Controller\Factory\SalesServiceControllerFactory;
use Sales\Controller\Factory\ShipControllerFactory;
use Sales\Controller\IndexController;
use Doctrine\ORM\Mapping\Driver\AnnotationDriver;
use Laminas\Router\Http\Segment;
use Sales\Controller\SalesServiceController;
use Sales\Controller\ShipController;
use Sales\Event\Factory\SalesListenerFactory;
use Sales\Event\SalesListener;
use Sales\Plugin\Factory\SalesPluginFactory;
use Sales\Plugin\SalesPlugin;
use Sales\Service\Factory\OrderChangeAmountManagerFactory;
use Sales\Service\Factory\OrderDeliveryAddressManagerFactory;
use Sales\Service\Factory\OrderDiscountRecordManagerFactory;
use Sales\Service\Factory\OrderGoodsEvaluationBaseManagerFactory;
use Sales\Service\Factory\OrderGoodsEvaluationManagerFactory;
use Sales\Service\Factory\OrderGoodsManagerFactory;
use Sales\Service\Factory\OrderGoodsReturnManagerFactory;
use Sales\Service\Factory\OrderManagerFactory;
use Sales\Service\Factory\OrderSelfLocationManagerFactory;
use Sales\Service\Factory\OrderStatusManagerFactory;
use Sales\Service\OrderChangeAmountManager;
use Sales\Service\OrderDeliveryAddressManager;
use Sales\Service\OrderDiscountRecordManager;
use Sales\Service\OrderGoodsEvaluationBaseManager;
use Sales\Service\OrderGoodsEvaluationManager;
use Sales\Service\OrderGoodsManager;
use Sales\Service\OrderGoodsReturnManager;
use Sales\Service\OrderManager;
use Sales\Service\OrderSelfLocationManager;
use Sales\Service\OrderStatusManager;
use Sales\View\Factory\SalesHelperFactory;
use Sales\View\SalesHelper;

return [
    'router' => [
        'routes' => [
            'sales' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/' . Config::ADMIN_PATH . '/sales[/:action[/:id]]',
                    'defaults' => [
                        'controller' => IndexController::class,
                        'action'    => 'index'
                    ]
                ]
            ],

            'sales-ship' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/' . Config::ADMIN_PATH . '/sales-ship[/:action[/:id]]',
                    'defaults' => [
                        'controller' => ShipController::class,
                        'action'    => 'index'
                    ]
                ]
            ],

            'sales-service' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/' . Config::ADMIN_PATH . '/sales-service[/:action[/:id]]',
                    'defaults' => [
                        'controller' => SalesServiceController::class,
                        'action'    => 'index'
                    ]
                ]
            ],

        ]

    ],

    'controllers' => [
        'factories' => [
            IndexController::class          => IndexControllerFactory::class,
            SalesServiceController::class   => SalesServiceControllerFactory::class,
            ShipController::class           => ShipControllerFactory::class
        ]
    ],

    'service_manager' => [
        'factories' => [
            OrderManager::class                 => OrderManagerFactory::class,
            OrderGoodsManager::class            => OrderGoodsManagerFactory::class,
            OrderDeliveryAddressManager::class  => OrderDeliveryAddressManagerFactory::class,
            OrderSelfLocationManager::class     => OrderSelfLocationManagerFactory::class,
            OrderStatusManager::class           => OrderStatusManagerFactory::class,
            OrderChangeAmountManager::class     => OrderChangeAmountManagerFactory::class,
            OrderGoodsEvaluationManager::class  => OrderGoodsEvaluationManagerFactory::class,
            OrderGoodsEvaluationBaseManager::class => OrderGoodsEvaluationBaseManagerFactory::class,
            OrderDiscountRecordManager::class   => OrderDiscountRecordManagerFactory::class,
            OrderGoodsReturnManager::class      => OrderGoodsReturnManagerFactory::class,

            SalesListener::class    => SalesListenerFactory::class
        ]
    ],

    'listeners' => [
        SalesListener::class
    ],

    'permission_filter' => include __DIR__ . '/permission.php',

    'controller_plugins' => [
        'factories' => [
            SalesPlugin::class => SalesPluginFactory::class
        ],
        'aliases'   => [
            'salesPlugin' => SalesPlugin::class
        ]
    ],

    'view_helpers' => [
        'factories' => [
            SalesHelper::class  => SalesHelperFactory::class
        ],
        'aliases' => [
            'salesHelper' => SalesHelper::class
        ],
    ],

    'translator' => [
        'translation_file_patterns' => [
            [
                'type' => 'gettext',
                'base_dir' => __DIR__ . '/../data/language',
                'pattern' => '%s.mo'
            ]
        ]
    ],

    'view_manager' => [
        'template_path_stack' => [
            __DIR__ . '/../view',
        ],
        'strategies' => [
            'ViewJsonStrategy',
        ]
    ],

    'doctrine' => [
        'driver' => [
            __NAMESPACE__ . '_driver' => [
                'class' => AnnotationDriver::class,
                'cache' => 'array',
                'paths' => [__DIR__ . '/../src/Entity']
            ],
            'orm_default' => [
                'drivers' => [
                    __NAMESPACE__ . '\Entity' => __NAMESPACE__ . '_driver'
                ]
            ]
        ]
    ]
];