<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Sales;

use Sales\Controller\IndexController;
use Sales\Controller\SalesServiceController;
use Sales\Controller\ShipController;

return [
    'Sales' => [
        'name' => '销售',
        'controllers' => [
           IndexController::class => [
               'name'   => '订单管理',
               'action' => [
                   'index', 'detail', 'payOrder', 'shipOrder', 'receiptOrder', 'cancelOrder', 'delete', 'printOrder',
                   'changeOrderAmount',
                   'sendOrderGoodsVirtual', 'showOrderExpressTrack', 'editOrderExpressNumber', 'orderPaymentLog'
               ],
               'actionNames' => [
                   'index'          => '订单列表',
                   'detail'         => '订单详情',
                   'payOrder'       => '订单支付',
                   'shipOrder'      => '订单发货',
                   'receiptOrder'   => '订单收货',
                   'cancelOrder'    => '订单取消',
                   'delete'         => '订单删除',
                   'deleteCancelOrder' => '一键删除已取消订单',
                   'printOrder'     => '订单打印',

                   'changeOrderAmount' => '订单金额修改',

                   'sendOrderGoodsVirtual' => '虚拟商品发货',
                   'showOrderExpressTrack' => '物流轨迹查看',
                   'editOrderExpressNumber'=> '快递单号修改',
                   'orderPaymentLog'       => '支付记录'
               ]
           ],
           ShipController::class => [
               'name' => '发货单',
               'action' => ['index'],
               'actionNames' => [
                   'index' => '发货单'
               ]
           ],
           SalesServiceController::class => [
               'name' => '售后管理',
               'action' => ['index', 'edit', 'view', 'delete'],
               'actionNames' => [
                   'index'  => '售后列表',
                   'edit'   => '售后审核',
                   'view'   => '售后详情',
                   'delete' => '售后删除'
               ]
           ]
        ]
    ]
];