<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Sales\Controller\Factory;

use Admin\Data\Config;
use Operation\Service\UserCouponManager;
use Sales\Controller\IndexController;
use Interop\Container\ContainerInterface;
use Laminas\Mvc\I18n\Translator;
use Laminas\ServiceManager\Factory\FactoryInterface;
use Sales\Service\OrderChangeAmountManager;
use Sales\Service\OrderDeliveryAddressManager;
use Sales\Service\OrderDiscountRecordManager;
use Sales\Service\OrderGoodsManager;
use Sales\Service\OrderManager;
use Sales\Service\OrderSelfLocationManager;
use Sales\Service\OrderStatusManager;
use User\Service\BalanceLogManager;
use User\Service\UserIntegralConfirmManager;
use User\Service\UserManager;

class IndexControllerFactory implements FactoryInterface
{
    public function __invoke(ContainerInterface $container, $requestedName, array $options = null)
    {
        $entityManager      = $container->get(Config::SHOP_DATABASE_MANAGER_WRITE);
        $translator         = $container->get(Translator::class);
        $orderManager       = $container->get(OrderManager::class);
        $orderChangeAmountManager   = $container->get(OrderChangeAmountManager::class);
        $orderDeliveryAddressManager= $container->get(OrderDeliveryAddressManager::class);
        $orderGoodsManager  = $container->get(OrderGoodsManager::class);
        $orderSelfLocationManager   = $container->get(OrderSelfLocationManager::class);
        $orderStatusManager = $container->get(OrderStatusManager::class);
        $userIntegralConfirmManager = $container->get(UserIntegralConfirmManager::class);
        $orderDiscountRecordManager = $container->get(OrderDiscountRecordManager::class);
        $userCouponManager  = $container->get(UserCouponManager::class);
        $userManager        = $container->get(UserManager::class);
        $balanceLogManager  = $container->get(BalanceLogManager::class);

        return new IndexController(
            $translator,
            $entityManager,
            $orderManager,
            $orderChangeAmountManager,
            $orderDeliveryAddressManager,
            $orderGoodsManager,
            $orderSelfLocationManager,
            $orderStatusManager,
            $userIntegralConfirmManager,
            $orderDiscountRecordManager,
            $userCouponManager,
            $userManager,
            $balanceLogManager
        );
    }
}