<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Sales\Controller\Factory;

use Admin\Data\Config;
use Interop\Container\ContainerInterface;
use Laminas\Mvc\I18n\Translator;
use Laminas\ServiceManager\Factory\FactoryInterface;
use Sales\Controller\SalesServiceController;
use Sales\Service\OrderGoodsManager;
use Sales\Service\OrderGoodsReturnManager;
use Sales\Service\OrderManager;
use User\Service\BalanceLogManager;
use User\Service\UserManager;

class SalesServiceControllerFactory implements FactoryInterface
{
    public function __invoke(ContainerInterface $container, $requestedName, array $options = null)
    {
        $translator         = $container->get(Translator::class);
        $entityManager      = $container->get(Config::SHOP_DATABASE_MANAGER_WRITE);
        $orderGoodsReturnManager = $container->get(OrderGoodsReturnManager::class);
        $balanceLogManager  = $container->get(BalanceLogManager::class);
        $userManager        = $container->get(UserManager::class);
        $orderManager       = $container->get(OrderManager::class);
        $orderGoodsManager       = $container->get(OrderGoodsManager::class);

        return new SalesServiceController(
            $translator,
            $entityManager,
            $orderGoodsReturnManager,
            $balanceLogManager,
            $userManager,
            $orderManager,
            $orderGoodsManager
        );
    }
}