<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Sales\Entity;

use Admin\Entity\BaseEntity;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;

/**
 * 订单
 * Class Order
 * @package Sales\Entity
 * @ORM\Entity(repositoryClass="Sales\Repository\OrderRepository")
 * @ORM\Table(name="dbshop_order")
 */
class Order extends BaseEntity
{
    /**
     * 订单自增id
     * @ORM\Id()
     *@ORM\Column(name="order_id", type="integer", length=11)
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $orderId;

    /**
     * 订单编号
     * @ORM\Column(name="order_sn", type="string", length=50)
     */
    private $orderSn;

    /**
     * 外部支付商户订单号
     * @ORM\Column(name="out_trade_no", type="string", length=50)
     */
    private $outTradeNo;

    /**
     * 订单金额
     * @ORM\Column(name="order_amount", type="decimal", scale=2)
     */
    private $orderAmount;

    /**
     * 基础货币金额，用于后台统计
     * @ORM\Column(name="base_order_amount", type="decimal", scale=2)
     */
    private $baseOrderAmount;

    /**
     * 商品总金额
     * @ORM\Column(name="goods_amount", type="decimal", scale=2)
     */
    private $goodsAmount;

    /**
     * 订单状态
     * @ORM\Column(name="order_status", type="integer", length=2)
     */
    private $orderStatus = 10;

    /**
     * 支付类型，在线支付 OnlinePay、货到付款 CashOnDelivery
     * @ORM\Column(name="payment_type", type="string", length=30)
     */
    private $paymentType;

    /**
     * 支付代码
     * @ORM\Column(name="payment_code", type="string", length=30)
     */
    private $paymentCode;

    /**
     * 支付名称
     * @ORM\Column(name="payment_name", type="string", length=100)
     */
    private $paymentName;

    /**
     * 支付凭证，银行转账时使用
     * @ORM\Column(name="payment_certification", type="string", length=500)
     */
    private $paymentCertification;

    /**
     * 支付完成时间
     * @ORM\Column(name="payment_finish_time", type="integer", length=10)
     */
    private $paymentFinishTime;

    /**
     * 发货类型，快递配送 delivery 、到店自提 selfFetch、autoDelivery 自动发货
     * @ORM\Column(name="delivery_type", type="string", length=30)
     */
    private $deliveryType;

    /**
     * 订单配送方式，默认为0，只有在快递配送时启用。1 整个订单统一配送，2 订单商品单独配送
     * @ORM\Column(name="delivery_mode", type="integer", length=1)
     */
    private $deliveryMode = 0;

    /**
     * 快递id
     * @ORM\Column(name="delivery_id", type="integer", length=11)
     */
    private $deliveryId;

    /**
     * 快递名称
     * @ORM\Column(name="delivery_name", type="string", length=200)
     */
    private $deliveryName;

    /**
     * 快递单号
     * @ORM\Column(name="express_number", type="string", length=50)
     */
    private $expressNumber;

    /**
     * 运费
     * @ORM\Column(name="shipping_fee", type="decimal", scale=2)
     */
    private $shippingFee;

    /**
     * 发货时间
     * @ORM\Column(name="express_time", type="integer", length=10)
     */
    private $expressTime;

    /**
     * 货币代码
     * @ORM\Column(name="currency_code", type="string", length=5)
     */
    private $currencyCode;

    /**
     * 货币符号
     * @ORM\Column(name="currency_symbol", type="string", length=5)
     */
    private $currencySymbol;

    /**
     * 订单重量，默认为0
     * @ORM\Column(name="order_weight_amount", type="integer", length=11)
     */
    private $orderWeightAmount;

    /**
     * 退货类型，默认为0无退货 退货1 退款2 退款退货3
     * @ORM\Column(name="order_return_type", type="integer", length=1)
     */
    private $orderReturnType;

    /**
     * 订单留言
     * @ORM\Column(name="order_message", type="string", length=500)
     */
    private $orderMessage;

    /**
     * 会员id
     * @ORM\Column(name="user_id", type="integer", length=11)
     */
    private $userId;

    /**
     * 会员名称
     * @ORM\Column(name="user_name", type="string", length=100)
     */
    private $userName;

    /**
     * 订单添加时间
     * @ORM\Column(name="order_add_time", type="integer", length=10)
     */
    private $orderAddTime;

    /**
     * 订单完成时间（收货）
     * @ORM\Column(name="order_finish_time", type="integer", length=10)
     */
    private $orderFinishTime;

    /**
     * @ORM\OneToMany(targetEntity="Sales\Entity\OrderGoods", mappedBy="order")
     * @ORM\JoinColumn(name="order_id", referencedColumnName="order_id")
     */
    protected $orderGoods;

    public function __construct()
    {
        $this->orderGoods = new ArrayCollection();
    }

    /**
     * @return ArrayCollection
     */
    public function getOrderGoods()
    {
        return $this->orderGoods;
    }

    /**
     * @param $orderGoods
     */
    public function addOrderGoods($orderGoods)
    {
        $this->orderGoods[] = $orderGoods;
    }

    /**
     * @return mixed
     */
    public function getOrderId()
    {
        return $this->orderId;
    }

    /**
     * @param mixed $orderId
     */
    public function setOrderId($orderId): void
    {
        $this->orderId = $orderId;
    }

    /**
     * @return mixed
     */
    public function getOrderSn()
    {
        return $this->orderSn;
    }

    /**
     * @param mixed $orderSn
     */
    public function setOrderSn($orderSn): void
    {
        $this->orderSn = $orderSn;
    }

    /**
     * @return mixed
     */
    public function getOutTradeNo()
    {
        return $this->outTradeNo;
    }

    /**
     * @param mixed $outTradeNo
     */
    public function setOutTradeNo($outTradeNo): void
    {
        $this->outTradeNo = $outTradeNo;
    }
    
    /**
     * @return mixed
     */
    public function getOrderAmount()
    {
        return $this->orderAmount;
    }

    /**
     * @param mixed $orderAmount
     */
    public function setOrderAmount($orderAmount): void
    {
        $this->orderAmount = $orderAmount;
    }

    /**
     * @return mixed
     */
    public function getBaseOrderAmount()
    {
        return $this->baseOrderAmount;
    }

    /**
     * @param mixed $baseOrderAmount
     */
    public function setBaseOrderAmount($baseOrderAmount): void
    {
        $this->baseOrderAmount = $baseOrderAmount;
    }

    /**
     * @return mixed
     */
    public function getGoodsAmount()
    {
        return $this->goodsAmount;
    }

    /**
     * @param mixed $goodsAmount
     */
    public function setGoodsAmount($goodsAmount): void
    {
        $this->goodsAmount = $goodsAmount;
    }

    /**
     * @return int
     */
    public function getOrderStatus(): int
    {
        return $this->orderStatus;
    }

    /**
     * @param int $orderStatus
     */
    public function setOrderStatus(int $orderStatus): void
    {
        $this->orderStatus = $orderStatus;
    }

    /**
     * @return mixed
     */
    public function getPaymentType()
    {
        return $this->paymentType;
    }

    /**
     * @param mixed $paymentType
     */
    public function setPaymentType($paymentType): void
    {
        $this->paymentType = $paymentType;
    }

    /**
     * @return mixed
     */
    public function getPaymentCode()
    {
        return $this->paymentCode;
    }

    /**
     * @param mixed $paymentCode
     */
    public function setPaymentCode($paymentCode): void
    {
        $this->paymentCode = $paymentCode;
    }

    /**
     * @return mixed
     */
    public function getPaymentName()
    {
        return $this->paymentName;
    }

    /**
     * @param mixed $paymentName
     */
    public function setPaymentName($paymentName): void
    {
        $this->paymentName = $paymentName;
    }

    /**
     * @return mixed
     */
    public function getPaymentCertification()
    {
        return $this->paymentCertification;
    }

    /**
     * @param mixed $paymentCertification
     */
    public function setPaymentCertification($paymentCertification): void
    {
        $this->paymentCertification = $paymentCertification;
    }

    /**
     * @return mixed
     */
    public function getPaymentFinishTime()
    {
        return $this->paymentFinishTime;
    }

    /**
     * @param mixed $paymentFinishTime
     */
    public function setPaymentFinishTime($paymentFinishTime): void
    {
        $this->paymentFinishTime = $paymentFinishTime;
    }

    /**
     * @return mixed
     */
    public function getDeliveryType()
    {
        return $this->deliveryType;
    }

    /**
     * @param mixed $deliveryType
     */
    public function setDeliveryType($deliveryType): void
    {
        $this->deliveryType = $deliveryType;
    }

    /**
     * @return int
     */
    public function getDeliveryMode(): int
    {
        return $this->deliveryMode;
    }

    /**
     * @param int $deliveryMode
     */
    public function setDeliveryMode(int $deliveryMode): void
    {
        $this->deliveryMode = $deliveryMode;
    }

    /**
     * @return mixed
     */
    public function getDeliveryId()
    {
        return $this->deliveryId;
    }

    /**
     * @param mixed $deliveryId
     */
    public function setDeliveryId($deliveryId): void
    {
        $this->deliveryId = $deliveryId;
    }

    /**
     * @return mixed
     */
    public function getDeliveryName()
    {
        return $this->deliveryName;
    }

    /**
     * @param mixed $deliveryName
     */
    public function setDeliveryName($deliveryName): void
    {
        $this->deliveryName = $deliveryName;
    }

    /**
     * @return mixed
     */
    public function getExpressNumber()
    {
        return $this->expressNumber;
    }

    /**
     * @param mixed $expressNumber
     */
    public function setExpressNumber($expressNumber): void
    {
        $this->expressNumber = $expressNumber;
    }

    /**
     * @return mixed
     */
    public function getShippingFee()
    {
        return $this->shippingFee;
    }

    /**
     * @param mixed $shippingFee
     */
    public function setShippingFee($shippingFee): void
    {
        $this->shippingFee = $shippingFee;
    }

    /**
     * @return mixed
     */
    public function getExpressTime()
    {
        return $this->expressTime;
    }

    /**
     * @param mixed $expressTime
     */
    public function setExpressTime($expressTime): void
    {
        $this->expressTime = $expressTime;
    }

    /**
     * @return mixed
     */
    public function getCurrencyCode()
    {
        return $this->currencyCode;
    }

    /**
     * @param mixed $currencyCode
     */
    public function setCurrencyCode($currencyCode): void
    {
        $this->currencyCode = $currencyCode;
    }

    /**
     * @return mixed
     */
    public function getCurrencySymbol()
    {
        return $this->currencySymbol;
    }

    /**
     * @param mixed $currencySymbol
     */
    public function setCurrencySymbol($currencySymbol): void
    {
        $this->currencySymbol = $currencySymbol;
    }

    /**
     * @return mixed
     */
    public function getOrderWeightAmount()
    {
        return $this->orderWeightAmount;
    }

    /**
     * @param mixed $orderWeightAmount
     */
    public function setOrderWeightAmount($orderWeightAmount): void
    {
        $this->orderWeightAmount = $orderWeightAmount;
    }

    /**
     * @return mixed
     */
    public function getOrderReturnType()
    {
        return $this->orderReturnType;
    }

    /**
     * @param mixed $orderReturnType
     */
    public function setOrderReturnType($orderReturnType): void
    {
        $this->orderReturnType = $orderReturnType;
    }

    /**
     * @return mixed
     */
    public function getOrderMessage()
    {
        return $this->orderMessage;
    }

    /**
     * @param mixed $orderMessage
     */
    public function setOrderMessage($orderMessage): void
    {
        $this->orderMessage = $orderMessage;
    }

    /**
     * @return mixed
     */
    public function getUserId()
    {
        return $this->userId;
    }

    /**
     * @param mixed $userId
     */
    public function setUserId($userId): void
    {
        $this->userId = $userId;
    }

    /**
     * @return mixed
     */
    public function getUserName()
    {
        return $this->userName;
    }

    /**
     * @param mixed $userName
     */
    public function setUserName($userName): void
    {
        $this->userName = $userName;
    }

    /**
     * @return mixed
     */
    public function getOrderAddTime()
    {
        return $this->orderAddTime;
    }

    /**
     * @param mixed $orderAddTime
     */
    public function setOrderAddTime($orderAddTime): void
    {
        $this->orderAddTime = $orderAddTime;
    }

    /**
     * @return mixed
     */
    public function getOrderFinishTime()
    {
        return $this->orderFinishTime;
    }

    /**
     * @param mixed $orderFinishTime
     */
    public function setOrderFinishTime($orderFinishTime): void
    {
        $this->orderFinishTime = $orderFinishTime;
    }
}