<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Sales\Entity;

use Admin\Entity\BaseEntity;
use Doctrine\ORM\Mapping as ORM;

/**
 * 订单金额修改历史
 * Class OrderChangeAmount
 * @package Sales\Entity
 * @ORM\Entity(repositoryClass="Sales\Repository\OrderChangeAmountRepository")
 * @ORM\Table(name="dbshop_order_change_amount")
 */
class OrderChangeAmount extends BaseEntity
{
    /**
     * 自增id
     * @ORM\Id()
     * @ORM\Column(name="order_change_id", type="integer", length=11)
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $orderChangeId;

    /**
     * 修改前的订单金额
     * @ORM\Column(name="order_amount", type="decimal", scale=2)
     */
    private $orderAmount;

    /**
     * 修改后的订单金额
     * @ORM\Column(name="order_original_amount", type="decimal", scale=2)
     */
    private $orderOriginalAmount;

    /**
     * 修改类型，+ 增加，- 减少
     * @ORM\Column(name="order_change_type", type="string", length=1)
     */
    private $orderChangeType;

    /**
     * 修改金额
     * @ORM\Column(name="order_change_num", type="decimal", scale=2)
     */
    private $orderChangeNum;

    /**
     * 操作时间
     * @ORM\Column(name="order_change_time", type="integer", length=10)
     */
    private $orderChangeTime;

    /**
     * 操作者
     * @ORM\Column(name="operate_user", type="string", length=100)
     */
    private $operateUser;

    /**
     * 金额修改备注
     * @ORM\Column(name="order_change_info", type="string", length=500)
     */
    private $orderChangeInfo;

    /**
     * 订单id
     * @ORM\Column(name="order_id", type="integer", length=11)
     */
    private $orderId;

    /**
     * @return mixed
     */
    public function getOrderChangeId()
    {
        return $this->orderChangeId;
    }

    /**
     * @param mixed $orderChangeId
     */
    public function setOrderChangeId($orderChangeId): void
    {
        $this->orderChangeId = $orderChangeId;
    }

    /**
     * @return mixed
     */
    public function getOrderAmount()
    {
        return $this->orderAmount;
    }

    /**
     * @param mixed $orderAmount
     */
    public function setOrderAmount($orderAmount): void
    {
        $this->orderAmount = $orderAmount;
    }

    /**
     * @return mixed
     */
    public function getOrderOriginalAmount()
    {
        return $this->orderOriginalAmount;
    }

    /**
     * @param mixed $orderOriginalAmount
     */
    public function setOrderOriginalAmount($orderOriginalAmount): void
    {
        $this->orderOriginalAmount = $orderOriginalAmount;
    }

    /**
     * @return mixed
     */
    public function getOrderChangeType()
    {
        return $this->orderChangeType;
    }

    /**
     * @param mixed $orderChangeType
     */
    public function setOrderChangeType($orderChangeType): void
    {
        $this->orderChangeType = $orderChangeType;
    }

    /**
     * @return mixed
     */
    public function getOrderChangeNum()
    {
        return $this->orderChangeNum;
    }

    /**
     * @param mixed $orderChangeNum
     */
    public function setOrderChangeNum($orderChangeNum): void
    {
        $this->orderChangeNum = $orderChangeNum;
    }

    /**
     * @return mixed
     */
    public function getOrderChangeTime()
    {
        return $this->orderChangeTime;
    }

    /**
     * @param mixed $orderChangeTime
     */
    public function setOrderChangeTime($orderChangeTime): void
    {
        $this->orderChangeTime = $orderChangeTime;
    }

    /**
     * @return mixed
     */
    public function getOperateUser()
    {
        return $this->operateUser;
    }

    /**
     * @param mixed $operateUser
     */
    public function setOperateUser($operateUser): void
    {
        $this->operateUser = $operateUser;
    }

    /**
     * @return mixed
     */
    public function getOrderChangeInfo()
    {
        return $this->orderChangeInfo;
    }

    /**
     * @param mixed $orderChangeInfo
     */
    public function setOrderChangeInfo($orderChangeInfo): void
    {
        $this->orderChangeInfo = $orderChangeInfo;
    }

    /**
     * @return mixed
     */
    public function getOrderId()
    {
        return $this->orderId;
    }

    /**
     * @param mixed $orderId
     */
    public function setOrderId($orderId): void
    {
        $this->orderId = $orderId;
    }
}