<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Sales\Entity;

use Admin\Entity\BaseEntity;
use Doctrine\ORM\Mapping as ORM;

/**
 * 订单配送地址
 * Class OrderDeliveryAddress
 * @package Sales\Entity
 * @ORM\Entity(repositoryClass="Sales\Repository\OrderDeliveryAddressRepository")
 * @ORM\Table(name="dbshop_order_delivery_address")
 */
class OrderDeliveryAddress extends BaseEntity
{
    /**
     * 自增id
     * @ORM\Id()
     * @ORM\Column(name="order_address_id", type="integer", length=11)
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $orderAddressId;

    /**
     * 收货人姓名
     * @ORM\Column(name="true_name", type="string", length=100)
     */
    private $trueName;

    /**
     * 地区
     * @ORM\Column(name="region_value", type="string", length=255)
     */
    private $regionValue;

    /**
     * 详细地址
     * @ORM\Column(name="address_info", type="string", length=500)
     */
    private $addressInfo;

    /**
     * 邮政编码
     * @ORM\Column(name="post_code", type="string", length=20)
     */
    private $postCode;

    /**
     * 电话所在区域编码
     * @ORM\Column(name="area_code", type="string", length=10)
     */
    private $areaCode;

    /**
     * 电话号码
     * @ORM\Column(name="phone", type="string", length=30)
     */
    private $phone;

    /**
     * 送货时间
     * @ORM\Column(name="delivery_time_info", type="string", length=300)
     */
    private $deliveryTimeInfo;

    /**
     * 订单id
     * @ORM\Column(name="order_id", type="integer", length=11)
     */
    private $orderId;

    /**
     * @return mixed
     */
    public function getOrderAddressId()
    {
        return $this->orderAddressId;
    }

    /**
     * @param mixed $orderAddressId
     */
    public function setOrderAddressId($orderAddressId): void
    {
        $this->orderAddressId = $orderAddressId;
    }

    /**
     * @return mixed
     */
    public function getTrueName()
    {
        return $this->trueName;
    }

    /**
     * @param mixed $trueName
     */
    public function setTrueName($trueName): void
    {
        $this->trueName = $trueName;
    }

    /**
     * @return mixed
     */
    public function getRegionValue()
    {
        return $this->regionValue;
    }

    /**
     * @param mixed $regionValue
     */
    public function setRegionValue($regionValue): void
    {
        $this->regionValue = $regionValue;
    }

    /**
     * @return mixed
     */
    public function getAddressInfo()
    {
        return $this->addressInfo;
    }

    /**
     * @param mixed $addressInfo
     */
    public function setAddressInfo($addressInfo): void
    {
        $this->addressInfo = $addressInfo;
    }

    /**
     * @return mixed
     */
    public function getPostCode()
    {
        return $this->postCode;
    }

    /**
     * @param mixed $postCode
     */
    public function setPostCode($postCode): void
    {
        $this->postCode = $postCode;
    }

    /**
     * @return mixed
     */
    public function getAreaCode()
    {
        return $this->areaCode;
    }

    /**
     * @param mixed $areaCode
     */
    public function setAreaCode($areaCode): void
    {
        $this->areaCode = $areaCode;
    }

    /**
     * @return mixed
     */
    public function getPhone()
    {
        return $this->phone;
    }

    /**
     * @param mixed $phone
     */
    public function setPhone($phone): void
    {
        $this->phone = $phone;
    }

    /**
     * @return mixed
     */
    public function getDeliveryTimeInfo()
    {
        return $this->deliveryTimeInfo;
    }

    /**
     * @param mixed $deliveryTimeInfo
     */
    public function setDeliveryTimeInfo($deliveryTimeInfo): void
    {
        $this->deliveryTimeInfo = $deliveryTimeInfo;
    }

    /**
     * @return mixed
     */
    public function getOrderId()
    {
        return $this->orderId;
    }

    /**
     * @param mixed $orderId
     */
    public function setOrderId($orderId): void
    {
        $this->orderId = $orderId;
    }
}