<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Sales\Entity;

use Admin\Entity\BaseEntity;
use Doctrine\ORM\Mapping as ORM;

/**
 * 订单优惠记录信息（比如优惠、满减、等等都再此记录）
 * Class OrderDiscountRecord
 * @package Sales\Entity
 * @ORM\Entity(repositoryClass="Sales\Repository\OrderDiscountRecordRepository")
 * @ORM\Table(name="dbshop_order_discount_record")
 */
class OrderDiscountRecord extends BaseEntity
{
    /**
     * 自增id
     * @ORM\Id()
     * @ORM\Column(name="record_id", type="integer", length=11)
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $recordId;

    /**
     * 优惠金额
     * @ORM\Column(name="discount_cost", type="decimal", scale=2)
     */
    private $discountCost = 0.00;

    /**
     * 优惠类型，如 discount 代表优惠促销规则，integral 消费积分
     * @ORM\Column(name="discount_type", type="string", length=30)
     */
    private $discountType;

    /**
     * 优惠描述，非规则标题和内容
     * @ORM\Column(name="discount_info", type="string", length=200)
     */
    private $discountInfo;

    /**
     * 订单id
     * @ORM\Column(name="order_id", type="integer", length=11)
     */
    private $orderId;

    /**
     * 会员id
     * @ORM\Column(name="user_id", type="integer", length=11)
     */
    private $userId;

    /**
     * 对应各种优惠的规则id
     * @ORM\Column(name="id", type="integer", length=11)
     */
    private $id;

    /**
     * @return mixed
     */
    public function getRecordId()
    {
        return $this->recordId;
    }

    /**
     * @param mixed $recordId
     */
    public function setRecordId($recordId): void
    {
        $this->recordId = $recordId;
    }

    /**
     * @return mixed
     */
    public function getDiscountCost()
    {
        return $this->discountCost;
    }

    /**
     * @param mixed $discountCost
     */
    public function setDiscountCost($discountCost): void
    {
        $this->discountCost = $discountCost;
    }

    /**
     * @return mixed
     */
    public function getDiscountType()
    {
        return $this->discountType;
    }

    /**
     * @param mixed $discountType
     */
    public function setDiscountType($discountType): void
    {
        $this->discountType = $discountType;
    }

    /**
     * @return mixed
     */
    public function getDiscountInfo()
    {
        return $this->discountInfo;
    }

    /**
     * @param mixed $discountInfo
     */
    public function setDiscountInfo($discountInfo): void
    {
        $this->discountInfo = $discountInfo;
    }

    /**
     * @return mixed
     */
    public function getOrderId()
    {
        return $this->orderId;
    }

    /**
     * @param mixed $orderId
     */
    public function setOrderId($orderId): void
    {
        $this->orderId = $orderId;
    }

    /**
     * @return mixed
     */
    public function getUserId()
    {
        return $this->userId;
    }

    /**
     * @param mixed $userId
     */
    public function setUserId($userId): void
    {
        $this->userId = $userId;
    }

    /**
     * @return mixed
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param mixed $id
     */
    public function setId($id): void
    {
        $this->id = $id;
    }
}