<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Sales\Entity;

use Admin\Entity\BaseEntity;
use Doctrine\ORM\Mapping as ORM;

/**
 * 订单商品
 * Class OrderGoods
 * @package Sales\Entity
 * @ORM\Entity(repositoryClass="Sales\Repository\OrderGoodsRepository")
 * @ORM\Table(name="dbshop_order_goods")
 */
class OrderGoods extends BaseEntity
{
    /**
     * 自增id
     * @ORM\Id()
     * @ORM\Column(name="order_goods_id", type="integer", length=11)
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $orderGoodsId;

    /**
     * 订单id
     * @ORM\Column(name="order_id", type="integer", length=11)
     */
    private $orderId;

    /**
     * 商品id
     * @ORM\Column(name="goods_id", type="integer", length=11)
     */
    private $goodsId;

    /**
     * 商品名称
     * @ORM\Column(name="goods_name", type="string", length=200)
     */
    private $goodsName;

    /**
     * 商品货号
     * @ORM\Column(name="goods_item", type="string", length=50)
     */
    private $goodsItem;

    /**
     * 订单商品价格
     * @ORM\Column(name="goods_price", type="decimal", scale=2)
     */
    private $goodsPrice;

    /**
     * 商品图片，如果是网络图片直接存储地址，如不是则将图片保存到对应目录
     * @ORM\Column(name="goods_image", type="string", length=200)
     */
    private $goodsImage;

    /**
     * 规格商品，规格信息
     * @ORM\Column(name="in_spec_goods_str", type="string", length=500)
     */
    private $inSpecGoodsStr;

    /**
     * 规格商品id
     * @ORM\Column(name="in_spec_goods_id", type="integer", length=11)
     */
    private $inSpecGoodsId;

    /**
     * 商品类型，1 实物，2 虚拟商品
     * @ORM\Column(name="goods_type", type="string", length=1)
     */
    private $goodsType;

    /**
     * 商品购买数量
     * @ORM\Column(name="buy_num", type="integer", length=11)
     */
    private $buyNum;

    /**
     * 商品金额（基础货币金额）用于统计
     * @ORM\Column(name="base_goods_amount", type="decimal", scale=2)
     */
    private $baseGoodsAmount;

    /**
     * 商品金额
     * @ORM\Column(name="goods_amount", type="decimal", scale=2)
     */
    private $goodsAmount;

    /**
     * 商品重量
     * @ORM\Column(name="goods_weight_amount", type="integer", length=11)
     */
    private $goodsWeightAmount;

    /**
     * 快递id（商品单独发送时）
     * @ORM\Column(name="delivery_id", type="integer", length=11)
     */
    private $deliveryId;

    /**
     * 快递名称（商品单独发送时）
     * @ORM\Column(name="delivery_name", type="string", length=200)
     */
    private $deliveryName;

    /**
     * 商品状态（发送，或者退货时）50 已发货，-10退货
     * @ORM\Column(name="goods_status", type="integer", length=2)
     */
    private $goodsStatus = 0;

    /**
     * 快递单号（商品单独发送时）
     * @ORM\Column(name="express_number", type="string", length=50)
     */
    private $expressNumber;

    /**
     * 快递发送时间（商品单独发送时）
     * @ORM\Column(name="express_time", type="integer", length=10)
     */
    private $expressTime;

    /**
     * 商品评价状态，0 未评价，1 已评价
     * @ORM\Column(name="evaluation_status", type="integer", length=1)
     */
    private $evaluationStatus = 0;
    /**
     * 会员id
     * @ORM\Column(name="user_id", type="integer", length=11)
     */
    private $userId;

    /**
     * @ORM\ManyToOne(targetEntity="Sales\Entity\Order", inversedBy="orderGoods")
     * @ORM\JoinColumn(name="order_id", referencedColumnName="order_id")
     */
    protected $order;

    /**
     * @return mixed
     */
    public function getOrder()
    {
        return $this->order;
    }

    /**
     * @param $order
     */
    public function setOrder($order)
    {
        $this->order = $order;
        $order->addOrderGoods($this);
    }

    /**
     * @return mixed
     */
    public function getOrderGoodsId()
    {
        return $this->orderGoodsId;
    }

    /**
     * @param mixed $orderGoodsId
     */
    public function setOrderGoodsId($orderGoodsId): void
    {
        $this->orderGoodsId = $orderGoodsId;
    }

    /**
     * @return mixed
     */
    public function getOrderId()
    {
        return $this->orderId;
    }

    /**
     * @param mixed $orderId
     */
    public function setOrderId($orderId): void
    {
        $this->orderId = $orderId;
    }

    /**
     * @return mixed
     */
    public function getGoodsId()
    {
        return $this->goodsId;
    }

    /**
     * @param mixed $goodsId
     */
    public function setGoodsId($goodsId): void
    {
        $this->goodsId = $goodsId;
    }

    /**
     * @return mixed
     */
    public function getGoodsName()
    {
        return $this->goodsName;
    }

    /**
     * @param mixed $goodsName
     */
    public function setGoodsName($goodsName): void
    {
        $this->goodsName = $goodsName;
    }

    /**
     * @return mixed
     */
    public function getGoodsItem()
    {
        return $this->goodsItem;
    }

    /**
     * @param mixed $goodsItem
     */
    public function setGoodsItem($goodsItem): void
    {
        $this->goodsItem = $goodsItem;
    }

    /**
     * @return mixed
     */
    public function getGoodsPrice()
    {
        return $this->goodsPrice;
    }

    /**
     * @param mixed $goodsPrice
     */
    public function setGoodsPrice($goodsPrice): void
    {
        $this->goodsPrice = $goodsPrice;
    }

    /**
     * @return mixed
     */
    public function getGoodsImage()
    {
        return $this->goodsImage;
    }

    /**
     * @param mixed $goodsImage
     */
    public function setGoodsImage($goodsImage): void
    {
        $this->goodsImage = $goodsImage;
    }

    /**
     * @return mixed
     */
    public function getInSpecGoodsStr()
    {
        return $this->inSpecGoodsStr;
    }

    /**
     * @param mixed $inSpecGoodsStr
     */
    public function setInSpecGoodsStr($inSpecGoodsStr): void
    {
        $this->inSpecGoodsStr = $inSpecGoodsStr;
    }

    /**
     * @return mixed
     */
    public function getInSpecGoodsId()
    {
        return $this->inSpecGoodsId;
    }

    /**
     * @param mixed $inSpecGoodsId
     */
    public function setInSpecGoodsId($inSpecGoodsId): void
    {
        $this->inSpecGoodsId = $inSpecGoodsId;
    }

    /**
     * @return mixed
     */
    public function getGoodsType()
    {
        return $this->goodsType;
    }

    /**
     * @param mixed $goodsType
     */
    public function setGoodsType($goodsType): void
    {
        $this->goodsType = $goodsType;
    }

    /**
     * @return mixed
     */
    public function getBuyNum()
    {
        return $this->buyNum;
    }

    /**
     * @param mixed $buyNum
     */
    public function setBuyNum($buyNum): void
    {
        $this->buyNum = $buyNum;
    }

    /**
     * @return mixed
     */
    public function getBaseGoodsAmount()
    {
        return $this->baseGoodsAmount;
    }

    /**
     * @param mixed $baseGoodsAmount
     */
    public function setBaseGoodsAmount($baseGoodsAmount): void
    {
        $this->baseGoodsAmount = $baseGoodsAmount;
    }

    /**
     * @return mixed
     */
    public function getGoodsAmount()
    {
        return $this->goodsAmount;
    }

    /**
     * @param mixed $goodsAmount
     */
    public function setGoodsAmount($goodsAmount): void
    {
        $this->goodsAmount = $goodsAmount;
    }

    /**
     * @return mixed
     */
    public function getGoodsWeightAmount()
    {
        return $this->goodsWeightAmount;
    }

    /**
     * @param mixed $goodsWeightAmount
     */
    public function setGoodsWeightAmount($goodsWeightAmount): void
    {
        $this->goodsWeightAmount = $goodsWeightAmount;
    }

    /**
     * @return mixed
     */
    public function getDeliveryId()
    {
        return $this->deliveryId;
    }

    /**
     * @param mixed $deliveryId
     */
    public function setDeliveryId($deliveryId): void
    {
        $this->deliveryId = $deliveryId;
    }

    /**
     * @return mixed
     */
    public function getDeliveryName()
    {
        return $this->deliveryName;
    }

    /**
     * @param mixed $deliveryName
     */
    public function setDeliveryName($deliveryName): void
    {
        $this->deliveryName = $deliveryName;
    }

    /**
     * @return mixed
     */
    public function getGoodsStatus()
    {
        return $this->goodsStatus;
    }

    /**
     * @param mixed $goodsStatus
     */
    public function setGoodsStatus($goodsStatus): void
    {
        $this->goodsStatus = $goodsStatus;
    }

    /**
     * @return mixed
     */
    public function getExpressNumber()
    {
        return $this->expressNumber;
    }

    /**
     * @param mixed $expressNumber
     */
    public function setExpressNumber($expressNumber): void
    {
        $this->expressNumber = $expressNumber;
    }

    /**
     * @return mixed
     */
    public function getExpressTime()
    {
        return $this->expressTime;
    }

    /**
     * @param mixed $expressTime
     */
    public function setExpressTime($expressTime): void
    {
        $this->expressTime = $expressTime;
    }

    /**
     * @return mixed
     */
    public function getEvaluationStatus()
    {
        return $this->evaluationStatus;
    }

    /**
     * @param mixed $evaluationStatus
     */
    public function setEvaluationStatus($evaluationStatus): void
    {
        $this->evaluationStatus = $evaluationStatus;
    }

    /**
     * @return mixed
     */
    public function getUserId()
    {
        return $this->userId;
    }

    /**
     * @param mixed $userId
     */
    public function setUserId($userId): void
    {
        $this->userId = $userId;
    }
}