<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Sales\Entity;

use Admin\Entity\BaseEntity;
use Doctrine\ORM\Mapping as ORM;

/**
 * 订单商品评价
 * Class OrderGoodsEvaluation
 * @package Sales\Entity
 * @ORM\Entity(repositoryClass="Sales\Repository\OrderGoodsEvaluationRepository")
 * @ORM\Table(name="dbshop_order_goods_evaluation")
 */
class OrderGoodsEvaluation extends BaseEntity
{
    /**
     * 自增id
     * @ORM\Id()
     * @ORM\Column(name="evaluation_id", type="integer", length=11)
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $evaluationId;

    /**
     * 会员id
     * @ORM\Column(name="user_id", type="integer", length=11)
     */
    private $userId;

    /**
     * 会员名称
     * @ORM\Column(name="user_name", type="string", length=100)
     */
    private $userName;

    /**
     * 评价内容
     * @ORM\Column(name="evaluation_body", type="string", length=2000)
     */
    private $evaluationBody;

    /**
     * 评价星数量，1-5
     * @ORM\Column(name="evaluation_star", type="integer", length=1)
     */
    private $evaluationStar;

    /**
     * 评价添加时间
     * @ORM\Column(name="evaluation_time", type="integer", length=10)
     */
    private $evaluationTime;

    /**
     * 评价显示状态，0 暂不显示，1 显示
     * @ORM\Column(name="evaluation_show_state", type="integer", length=1)
     */
    private $evaluationShowState = 1;

    /**
     * 追评内容
     * @ORM\Column(name="add_evaluation_body", type="string", length=2000)
     */
    private $addEvaluationBody;

    /**
     * 追评时间
     * @ORM\Column(name="add_evaluation_time", type="integer", length=10)
     */
    private $addEvaluationTime;

    /**
     * 店主回复内容
     * @ORM\Column(name="reply_body", type="string", length=2000)
     */
    private $replyBody;

    /**
     * 店主回复时间
     * @ORM\Column(name="reply_time", type="integer", length=10)
     */
    private $replyTime;

    /**
     * 评价回复人名称
     * @ORM\Column(name="reply_user", type="string", length=100)
     */
    private $replyUser;

    /**
     * 商品id
     * @ORM\Column(name="goods_id", type="integer", length=11)
     */
    private $goodsId;

    /**
     * 订单商品id
     * @ORM\Column(name="order_goods_id", type="integer",length=11)
     */
    private $orderGoodsId;

    /**
     * @return mixed
     */
    public function getEvaluationId()
    {
        return $this->evaluationId;
    }

    /**
     * @param mixed $evaluationId
     */
    public function setEvaluationId($evaluationId): void
    {
        $this->evaluationId = $evaluationId;
    }

    /**
     * @return mixed
     */
    public function getUserId()
    {
        return $this->userId;
    }

    /**
     * @param mixed $userId
     */
    public function setUserId($userId): void
    {
        $this->userId = $userId;
    }

    /**
     * @return mixed
     */
    public function getUserName()
    {
        return $this->userName;
    }

    /**
     * @param mixed $userName
     */
    public function setUserName($userName): void
    {
        $this->userName = $userName;
    }

    /**
     * @return mixed
     */
    public function getEvaluationBody()
    {
        return $this->evaluationBody;
    }

    /**
     * @param mixed $evaluationBody
     */
    public function setEvaluationBody($evaluationBody): void
    {
        $this->evaluationBody = $evaluationBody;
    }

    /**
     * @return mixed
     */
    public function getEvaluationStar()
    {
        return $this->evaluationStar;
    }

    /**
     * @param mixed $evaluationStar
     */
    public function setEvaluationStar($evaluationStar): void
    {
        $this->evaluationStar = $evaluationStar;
    }

    /**
     * @return mixed
     */
    public function getEvaluationTime()
    {
        return $this->evaluationTime;
    }

    /**
     * @param mixed $evaluationTime
     */
    public function setEvaluationTime($evaluationTime): void
    {
        $this->evaluationTime = $evaluationTime;
    }

    /**
     * @return mixed
     */
    public function getEvaluationShowState()
    {
        return $this->evaluationShowState;
    }

    /**
     * @param mixed $evaluationShowState
     */
    public function setEvaluationShowState($evaluationShowState): void
    {
        $this->evaluationShowState = $evaluationShowState;
    }

    /**
     * @return mixed
     */
    public function getAddEvaluationBody()
    {
        return $this->addEvaluationBody;
    }

    /**
     * @param mixed $addEvaluationBody
     */
    public function setAddEvaluationBody($addEvaluationBody): void
    {
        $this->addEvaluationBody = $addEvaluationBody;
    }

    /**
     * @return mixed
     */
    public function getAddEvaluationTime()
    {
        return $this->addEvaluationTime;
    }

    /**
     * @param mixed $addEvaluationTime
     */
    public function setAddEvaluationTime($addEvaluationTime): void
    {
        $this->addEvaluationTime = $addEvaluationTime;
    }

    /**
     * @return mixed
     */
    public function getReplyBody()
    {
        return $this->replyBody;
    }

    /**
     * @param mixed $replyBody
     */
    public function setReplyBody($replyBody): void
    {
        $this->replyBody = $replyBody;
    }

    /**
     * @return mixed
     */
    public function getReplyTime()
    {
        return $this->replyTime;
    }

    /**
     * @param mixed $replyTime
     */
    public function setReplyTime($replyTime): void
    {
        $this->replyTime = $replyTime;
    }

    /**
     * @return mixed
     */
    public function getReplyUser()
    {
        return $this->replyUser;
    }

    /**
     * @param mixed $replyUser
     */
    public function setReplyUser($replyUser): void
    {
        $this->replyUser = $replyUser;
    }

    /**
     * @return mixed
     */
    public function getGoodsId()
    {
        return $this->goodsId;
    }

    /**
     * @param mixed $goodsId
     */
    public function setGoodsId($goodsId): void
    {
        $this->goodsId = $goodsId;
    }

    /**
     * @return mixed
     */
    public function getOrderGoodsId()
    {
        return $this->orderGoodsId;
    }

    /**
     * @param mixed $orderGoodsId
     */
    public function setOrderGoodsId($orderGoodsId): void
    {
        $this->orderGoodsId = $orderGoodsId;
    }
}