<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Sales\Entity;

use Admin\Entity\BaseEntity;
use Doctrine\ORM\Mapping as ORM;

/**
 * 商品评价基本表
 * Class OrderGoodsEvaluationBase
 * @package Sales\Entity
 * @ORM\Entity(repositoryClass="Sales\Repository\OrderGoodsEvaluationBaseRepository")
 * @ORM\Table(name="dbshop_order_goods_evaluation_base")
 */
class OrderGoodsEvaluationBase extends BaseEntity
{
    /**
     * 自增id
     * @ORM\Id()
     * @ORM\Column(name="evaluation_base_id", type="integer", length=11)
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $evaluationBaseId;

    /**
     * 评价的商品id
     * @ORM\Column(name="goods_id", type="integer", length=11)
     */
    private $goodsId;

    /**
     * 最新评价人
     * @ORM\Column(name="evaluation_last_user", type="string", length=100)
     */
    private $evaluationLastUser;

    /**
     * 最新评价时间
     * @ORM\Column(name="evaluation_last_time", type="integer", length=10)
     */
    private $evaluationLastTime;

    /**
     * 评价数
     * @ORM\Column(name="evaluation_count", type="integer", length=11)
     */
    private $evaluationCount;

    /**
     * @return mixed
     */
    public function getEvaluationBaseId()
    {
        return $this->evaluationBaseId;
    }

    /**
     * @param mixed $evaluationBaseId
     */
    public function setEvaluationBaseId($evaluationBaseId): void
    {
        $this->evaluationBaseId = $evaluationBaseId;
    }

    /**
     * @return mixed
     */
    public function getGoodsId()
    {
        return $this->goodsId;
    }

    /**
     * @param mixed $goodsId
     */
    public function setGoodsId($goodsId): void
    {
        $this->goodsId = $goodsId;
    }

    /**
     * @return mixed
     */
    public function getEvaluationLastUser()
    {
        return $this->evaluationLastUser;
    }

    /**
     * @param mixed $evaluationLastUser
     */
    public function setEvaluationLastUser($evaluationLastUser): void
    {
        $this->evaluationLastUser = $evaluationLastUser;
    }

    /**
     * @return mixed
     */
    public function getEvaluationLastTime()
    {
        return $this->evaluationLastTime;
    }

    /**
     * @param mixed $evaluationLastTime
     */
    public function setEvaluationLastTime($evaluationLastTime): void
    {
        $this->evaluationLastTime = $evaluationLastTime;
    }

    /**
     * @return mixed
     */
    public function getEvaluationCount()
    {
        return $this->evaluationCount;
    }

    /**
     * @param mixed $evaluationCount
     */
    public function setEvaluationCount($evaluationCount): void
    {
        $this->evaluationCount = $evaluationCount;
    }
}