<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Sales\Entity;

use Admin\Entity\BaseEntity;
use Doctrine\ORM\Mapping as ORM;

/**
 * 退款、退货、换货
 * Class OrderGoodsReturn
 * @package Sales\Entity
 * @ORM\Entity(repositoryClass="Sales\Repository\OrderGoodsReturnRepository")
 * @ORM\Table(name="dbshop_order_goods_return")
 */
class OrderGoodsReturn extends BaseEntity
{
    /**
     * 自增id
     * @ORM\Id()
     * @ORM\Column(name="return_id", type="integer", length=11)
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $returnId;

    /**
     * 订单id
     * @ORM\Column(name="order_id", type="integer", length=11)
     */
    private $orderId;

    /**
     * 订单编号
     * @ORM\Column(name="order_sn", type="string", length=50)
     */
    private $orderSn;

    /**
     * 客户id
     * @ORM\Column(name="user_id", type="integer", length=11)
     */
    private $userId;

    /**
     * 客户名称
     * @ORM\Column(name="user_name", type="string", length=100)
     */
    private $userName;

    /**
     * 订单商品id
     * @ORM\Column(name="order_goods_id", type="integer", length=11)
     */
    private $orderGoodsId;

    /**
     * 类型，1 退货退款，2 退款，3 换货
     * @ORM\Column(name="return_type", type="integer", length=1)
     */
    private $returnType;

    /**
     * 退款、退货、换货 原因
     * @ORM\Column(name="return_reason", type="string", length=200)
     */
    private $returnReason;

    /**
     * 退款退货金额
     * @ORM\Column(name="return_amount", type="decimal", scale=2)
     */
    private $returnAmount = 0.00;

    /**
     * 描述
     * @ORM\Column(name="return_info", type="string", length=1000)
     */
    private $returnInfo;

    /**
     * 退款支付类型 balancePay 退款到余额，otherPay 退款到银行或第三方支付
     * @ORM\Column(name="refund_pay_type", type="string", length=20)
     */
    private $refundPayType;

    /**
     * 支付名称（银行名称）
     * @ORM\Column(name="refund_pay_name", type="string", length=200)
     */
    private $refundPayName;

    /**
     * 姓名
     * @ORM\Column(name="refund_user", type="string", length=100)
     */
    private $refundUser;

    /**
     * 账号（银行卡好）
     * @ORM\Column(name="refund_account", type="string", length=100)
     */
    private $refundAccount;

    /**
     * 退货状态，1 等待审核，2 审核通过，3 驳回申请
     * @ORM\Column(name="return_state", type="integer", length=1)
     */
    private $returnState = 1;

    /**
     * 添加时间
     * @ORM\Column(name="add_time", type="integer", length=10)
     */
    private $addTime;

    /**
     * 审核说明
     * @ORM\Column(name="review_info", type="string", length=500)
     */
    private $reviewInfo;

    /**
     * 审核时间
     * @ORM\Column(name="review_time", type="integer", length=10)
     */
    private $reviewTime = 0;

    /**
     * @return mixed
     */
    public function getReturnId()
    {
        return $this->returnId;
    }

    /**
     * @param mixed $returnId
     */
    public function setReturnId($returnId): void
    {
        $this->returnId = $returnId;
    }

    /**
     * @return mixed
     */
    public function getOrderId()
    {
        return $this->orderId;
    }

    /**
     * @param mixed $orderId
     */
    public function setOrderId($orderId): void
    {
        $this->orderId = $orderId;
    }

    /**
     * @return mixed
     */
    public function getOrderSn()
    {
        return $this->orderSn;
    }

    /**
     * @param mixed $orderSn
     */
    public function setOrderSn($orderSn): void
    {
        $this->orderSn = $orderSn;
    }

    /**
     * @return mixed
     */
    public function getUserId()
    {
        return $this->userId;
    }

    /**
     * @param mixed $userId
     */
    public function setUserId($userId): void
    {
        $this->userId = $userId;
    }

    /**
     * @return mixed
     */
    public function getUserName()
    {
        return $this->userName;
    }

    /**
     * @param mixed $userName
     */
    public function setUserName($userName): void
    {
        $this->userName = $userName;
    }

    /**
     * @return mixed
     */
    public function getOrderGoodsId()
    {
        return $this->orderGoodsId;
    }

    /**
     * @param mixed $orderGoodsId
     */
    public function setOrderGoodsId($orderGoodsId): void
    {
        $this->orderGoodsId = $orderGoodsId;
    }

    /**
     * @return mixed
     */
    public function getReturnType()
    {
        return $this->returnType;
    }

    /**
     * @param mixed $returnType
     */
    public function setReturnType($returnType): void
    {
        $this->returnType = $returnType;
    }

    /**
     * @return mixed
     */
    public function getReturnReason()
    {
        return $this->returnReason;
    }

    /**
     * @param mixed $returnReason
     */
    public function setReturnReason($returnReason): void
    {
        $this->returnReason = $returnReason;
    }

    /**
     * @return mixed
     */
    public function getReturnAmount()
    {
        return $this->returnAmount;
    }

    /**
     * @param mixed $returnAmount
     */
    public function setReturnAmount($returnAmount): void
    {
        $this->returnAmount = $returnAmount;
    }

    /**
     * @return mixed
     */
    public function getReturnInfo()
    {
        return $this->returnInfo;
    }

    /**
     * @param mixed $returnInfo
     */
    public function setReturnInfo($returnInfo): void
    {
        $this->returnInfo = $returnInfo;
    }

    /**
     * @return mixed
     */
    public function getRefundPayType()
    {
        return $this->refundPayType;
    }

    /**
     * @param mixed $refundPayType
     */
    public function setRefundPayType($refundPayType): void
    {
        $this->refundPayType = $refundPayType;
    }

    /**
     * @return mixed
     */
    public function getRefundPayName()
    {
        return $this->refundPayName;
    }

    /**
     * @param mixed $refundPayName
     */
    public function setRefundPayName($refundPayName): void
    {
        $this->refundPayName = $refundPayName;
    }

    /**
     * @return mixed
     */
    public function getRefundUser()
    {
        return $this->refundUser;
    }

    /**
     * @param mixed $refundUser
     */
    public function setRefundUser($refundUser): void
    {
        $this->refundUser = $refundUser;
    }

    /**
     * @return mixed
     */
    public function getRefundAccount()
    {
        return $this->refundAccount;
    }

    /**
     * @param mixed $refundAccount
     */
    public function setRefundAccount($refundAccount): void
    {
        $this->refundAccount = $refundAccount;
    }

    /**
     * @return mixed
     */
    public function getReturnState()
    {
        return $this->returnState;
    }

    /**
     * @param mixed $returnState
     */
    public function setReturnState($returnState): void
    {
        $this->returnState = $returnState;
    }

    /**
     * @return mixed
     */
    public function getAddTime()
    {
        return $this->addTime;
    }

    /**
     * @param mixed $addTime
     */
    public function setAddTime($addTime): void
    {
        $this->addTime = $addTime;
    }

    /**
     * @return mixed
     */
    public function getReviewInfo()
    {
        return $this->reviewInfo;
    }

    /**
     * @param mixed $reviewInfo
     */
    public function setReviewInfo($reviewInfo): void
    {
        $this->reviewInfo = $reviewInfo;
    }

    /**
     * @return mixed
     */
    public function getReviewTime()
    {
        return $this->reviewTime;
    }

    /**
     * @param mixed $reviewTime
     */
    public function setReviewTime($reviewTime): void
    {
        $this->reviewTime = $reviewTime;
    }
}