<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Sales\Entity;

use Admin\Entity\BaseEntity;
use Doctrine\ORM\Mapping as ORM;

/**
 * 订单自提点（下单后生成）
 * Class OrderSelfLocation
 * @package Sales\Entity
 * @ORM\Entity(repositoryClass="Sales\Repository\OrderSelfLocationRepository")
 * @ORM\Table(name="dbshop_order_self_location")
 */
class OrderSelfLocation extends BaseEntity
{
    /**
     * 自增id
     * @ORM\Id()
     * @ORM\Column(name="order_location_id", type="integer", length=11)
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $orderLocationId;

    /**
     * 自提点id
     * @ORM\Column(name="location_id", type="integer", length=11)
     */
    private $locationId;

    /**
     * 订单id
     * @ORM\Column(name="order_id", type="integer", length=11)
     */
    private $orderId;

    /**
     * 自提点名称
     * @ORM\Column(name="location_name", type="string", length=200)
     */
    private $locationName;

    /**
     * 地区
     * @ORM\Column(name="region_info", type="string", length=150)
     */
    private $regionInfo;

    /**
     * 详细地址
     * @ORM\Column(name="location_address", type="string", length=200)
     */
    private $locationAddress;

    /**
     * 坐标
     * @ORM\Column(name="location_geo_coding", type="string", length=50)
     */
    private $locationGeoCoding;

    /**
     * 联系电话
     * @ORM\Column(name="location_phone", type="string", length=30)
     */
    private $locationPhone;

    /**
     * 联系人
     * @ORM\Column(name="location_user", type="string", length=200)
     */
    private $locationUser;

    /**
     * 营业时间
     * @ORM\Column(name="location_business_hours", type="string", length=200)
     */
    private $locationBusinessHours;

    /**
     * 提货码
     * @ORM\Column(name="take_code", type="string", length=30)
     */
    private $takeCode;

    /**
     * @return mixed
     */
    public function getOrderLocationId()
    {
        return $this->orderLocationId;
    }

    /**
     * @param mixed $orderLocationId
     */
    public function setOrderLocationId($orderLocationId): void
    {
        $this->orderLocationId = $orderLocationId;
    }

    /**
     * @return mixed
     */
    public function getLocationId()
    {
        return $this->locationId;
    }

    /**
     * @param mixed $locationId
     */
    public function setLocationId($locationId): void
    {
        $this->locationId = $locationId;
    }

    /**
     * @return mixed
     */
    public function getOrderId()
    {
        return $this->orderId;
    }

    /**
     * @param mixed $orderId
     */
    public function setOrderId($orderId): void
    {
        $this->orderId = $orderId;
    }

    /**
     * @return mixed
     */
    public function getLocationName()
    {
        return $this->locationName;
    }

    /**
     * @param mixed $locationName
     */
    public function setLocationName($locationName): void
    {
        $this->locationName = $locationName;
    }

    /**
     * @return mixed
     */
    public function getRegionInfo()
    {
        return $this->regionInfo;
    }

    /**
     * @param mixed $regionInfo
     */
    public function setRegionInfo($regionInfo): void
    {
        $this->regionInfo = $regionInfo;
    }

    /**
     * @return mixed
     */
    public function getLocationAddress()
    {
        return $this->locationAddress;
    }

    /**
     * @param mixed $locationAddress
     */
    public function setLocationAddress($locationAddress): void
    {
        $this->locationAddress = $locationAddress;
    }

    /**
     * @return mixed
     */
    public function getLocationGeoCoding()
    {
        return $this->locationGeoCoding;
    }

    /**
     * @param mixed $locationGeoCoding
     */
    public function setLocationGeoCoding($locationGeoCoding): void
    {
        $this->locationGeoCoding = $locationGeoCoding;
    }

    /**
     * @return mixed
     */
    public function getLocationPhone()
    {
        return $this->locationPhone;
    }

    /**
     * @param mixed $locationPhone
     */
    public function setLocationPhone($locationPhone): void
    {
        $this->locationPhone = $locationPhone;
    }

    /**
     * @return mixed
     */
    public function getLocationUser()
    {
        return $this->locationUser;
    }

    /**
     * @param mixed $locationUser
     */
    public function setLocationUser($locationUser): void
    {
        $this->locationUser = $locationUser;
    }

    /**
     * @return mixed
     */
    public function getLocationBusinessHours()
    {
        return $this->locationBusinessHours;
    }

    /**
     * @param mixed $locationBusinessHours
     */
    public function setLocationBusinessHours($locationBusinessHours): void
    {
        $this->locationBusinessHours = $locationBusinessHours;
    }

    /**
     * @return mixed
     */
    public function getTakeCode()
    {
        return $this->takeCode;
    }

    /**
     * @param mixed $takeCode
     */
    public function setTakeCode($takeCode): void
    {
        $this->takeCode = $takeCode;
    }
}