<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Sales\Entity;

use Admin\Entity\BaseEntity;
use Doctrine\ORM\Mapping as ORM;

/**
 * 订单状态表
 * Class OrderStatus
 * @package Sales\Entity
 * @ORM\Entity(repositoryClass="Sales\Repository\OrderStatusRepository")
 * @ORM\Table(name="dbshop_order_status")
 */
class OrderStatus extends BaseEntity
{
    /**
     * 自增id
     * @ORM\Id()
     * @ORM\Column(name="status_id", type="integer", length=11)
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $statusId;

    /**
     * 订单状态
     * @ORM\Column(name="order_status", type="integer", length=2)
     */
    private $orderStatus;

    /**
     * 操作者
     * @ORM\Column(name="operate_user", type="string", length=100)
     */
    private $operateUser;

    /**
     * 订单Id
     * @ORM\Column(name="order_id", type="integer", length=11)
     */
    private $orderId;

    /**
     * 状态备注
     * @ORM\Column(name="status_info", type="string", length=255)
     */
    private $statusInfo;

    /**
     * 时间
     * @ORM\Column(name="status_time", type="integer", length=10)
     */
    private $statusTime;

    /**
     * @return mixed
     */
    public function getStatusId()
    {
        return $this->statusId;
    }

    /**
     * @param mixed $statusId
     */
    public function setStatusId($statusId): void
    {
        $this->statusId = $statusId;
    }

    /**
     * @return mixed
     */
    public function getOrderStatus()
    {
        return $this->orderStatus;
    }

    /**
     * @param mixed $orderStatus
     */
    public function setOrderStatus($orderStatus): void
    {
        $this->orderStatus = $orderStatus;
    }

    /**
     * @return mixed
     */
    public function getOperateUser()
    {
        return $this->operateUser;
    }

    /**
     * @param mixed $operateUser
     */
    public function setOperateUser($operateUser): void
    {
        $this->operateUser = $operateUser;
    }

    /**
     * @return mixed
     */
    public function getOrderId()
    {
        return $this->orderId;
    }

    /**
     * @param mixed $orderId
     */
    public function setOrderId($orderId): void
    {
        $this->orderId = $orderId;
    }

    /**
     * @return mixed
     */
    public function getStatusInfo()
    {
        return $this->statusInfo;
    }

    /**
     * @param mixed $statusInfo
     */
    public function setStatusInfo($statusInfo): void
    {
        $this->statusInfo = $statusInfo;
    }

    /**
     * @return mixed
     */
    public function getStatusTime()
    {
        return $this->statusTime;
    }

    /**
     * @param mixed $statusTime
     */
    public function setStatusTime($statusTime): void
    {
        $this->statusTime = $statusTime;
    }
}