<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Sales\Event\Factory;

use Admin\Data\Config;
use Goods\Service\GoodsInSpecGoodsManager;
use Goods\Service\GoodsSalesRecordManager;
use Goods\Service\GoodsStockManager;
use Interop\Container\ContainerInterface;
use Laminas\ServiceManager\Factory\FactoryInterface;
use Sales\Event\SalesListener;
use Shop\Service\ShopUserManager;
use User\Service\IntegralLogManager;
use User\Service\UserIntegralConfirmManager;

class SalesListenerFactory implements FactoryInterface
{
    public function __invoke(ContainerInterface $container, $requestedName, array $options = null)
    {
        $entityManager              = $container->get(Config::SHOP_DATABASE_MANAGER_WRITE);
        $goodsStockManager          = $container->get(GoodsStockManager::class);
        $goodsInSpecGoodsManager    = $container->get(GoodsInSpecGoodsManager::class);
        $goodsSalesRecordManager    = $container->get(GoodsSalesRecordManager::class);
        $shopUserManager            = $container->get(ShopUserManager::class);
        $integralLogManager         = $container->get(IntegralLogManager::class);
        $userIntegralConfirmManager = $container->get(UserIntegralConfirmManager::class);

        return new SalesListener(
            $entityManager,
            $goodsStockManager,
            $goodsInSpecGoodsManager,
            $goodsSalesRecordManager,
            $shopUserManager,
            $integralLogManager,
            $userIntegralConfirmManager
        );
    }
}